/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.helmrepo.maven.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.tar.TarGZipArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.InterpolatorFilterReader;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.honton.chas.helmrepo.maven.plugin.HelmGoal;
import org.honton.chas.helmrepo.maven.plugin.SemVer;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class HelmPackage
extends HelmGoal {
    @Parameter(defaultValue="true")
    boolean attach;
    @Parameter(defaultValue="true")
    boolean filter;
    @Parameter(defaultValue="src/helm")
    File helmDir;
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}-${project.version}.tgz", required=true, readonly=true)
    File destFile;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    MavenSession session;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Component
    MavenProjectHelper projectHelper;

    @Override
    protected final void doExecute() throws IOException {
        File chartDir = new File(this.helmDir, this.project.getArtifactId());
        if (this.helmDir.isDirectory() && chartDir.isDirectory()) {
            this.checkChartFile(chartDir);
            this.packageChart(this.helmDir);
        } else {
            this.getLog().info((CharSequence)("Helm chart not found at " + chartDir + ", skipping 'package'"));
        }
    }

    private void checkChartFile(File chartDir) throws IOException {
        File chartFile = new File(chartDir, "Chart.yaml");
        if (!chartFile.canRead()) {
            String error = "Cannot read " + chartFile;
            this.getLog().error((CharSequence)error);
            throw new IOException(error);
        }
        InputStream is = new FileInputStream(chartFile);
        if (this.filter) {
            is = this.createStream(is);
        }
        Map chart = (Map)new Yaml().load(is);
        if (!this.project.getArtifactId().equals(chart.get("name"))) {
            String error = "Chart name does not equal the required value of " + this.project.getArtifactId();
            this.getLog().error((CharSequence)error);
            throw new IOException(error);
        }
        SemVer.valueOf((String)chart.get("version"));
    }

    private void packageChart(File helmDir) throws IOException {
        DefaultFileSet fileSet = DefaultFileSet.fileSet((File)helmDir);
        fileSet.setIncludes(new String[]{this.project.getArtifactId() + "/**/*.*"});
        if (this.filter) {
            fileSet.setStreamTransformer((r, is) -> this.createStream(is));
        }
        TarGZipArchiver archiver = new TarGZipArchiver();
        archiver.addFileSet((FileSet)fileSet);
        archiver.setDestFile(this.destFile);
        archiver.createArchive();
        if ("tgz".equals(this.project.getPackaging())) {
            this.project.getArtifact().setFile(this.destFile);
        } else if (this.attach) {
            this.projectHelper.attachArtifact(this.project, "tgz", this.destFile);
        }
    }

    private InputStream createStream(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return new ReaderInputStream((Reader)new InterpolatorFilterReader((Reader)reader, this.createInterpolator()), StandardCharsets.UTF_8);
    }

    private PropertiesBasedValueSource sessionSource() {
        File basedir = this.session.getRepositorySession().getLocalRepositoryManager().getRepository().getBasedir();
        Properties properties = new Properties();
        properties.setProperty("settings.localRepository", basedir.toString());
        properties.putAll((Map<?, ?>)this.session.getSystemProperties());
        properties.putAll((Map<?, ?>)this.session.getUserProperties());
        return new PropertiesBasedValueSource(properties);
    }

    private PrefixedValueSourceWrapper envSource() {
        return new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                return System.getenv(expression);
            }
        }, "env");
    }

    private PrefixedValueSourceWrapper projectSource() {
        return new PrefixedValueSourceWrapper((ValueSource)new ObjectBasedValueSource((Object)this.project), "project");
    }

    private PrefixedValueSourceWrapper projectPropertiesSource() {
        return new PrefixedValueSourceWrapper((ValueSource)new PropertiesBasedValueSource(this.project.getProperties()), "project.properties", true);
    }

    private Interpolator createInterpolator() {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setEscapeString("\\");
        interpolator.addValueSource((ValueSource)this.envSource());
        interpolator.addValueSource((ValueSource)this.sessionSource());
        interpolator.addValueSource((ValueSource)this.projectSource());
        interpolator.addValueSource((ValueSource)this.projectPropertiesSource());
        return interpolator;
    }
}

