/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.helmrepo.maven.plugin;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.honton.chas.helmrepo.maven.plugin.CommandLineGenerator;
import org.honton.chas.helmrepo.maven.plugin.CommandOptions;
import org.honton.chas.helmrepo.maven.plugin.GlobalReleaseOptions;
import org.honton.chas.helmrepo.maven.plugin.HelmGoal;
import org.honton.chas.helmrepo.maven.plugin.KubernetesInfo;
import org.honton.chas.helmrepo.maven.plugin.ReleaseHelper;
import org.honton.chas.helmrepo.maven.plugin.ReleaseInfo;
import org.honton.chas.helmrepo.maven.plugin.ReleaseState;

public abstract class HelmRelease
extends HelmGoal
implements GlobalReleaseOptions,
CommandOptions {
    private static final Pattern WARNING = Pattern.compile("\\[?(warning)]?:? ?(.+)", 2);
    @Parameter
    String valueYaml;
    @Parameter
    File valuesFile;
    @Parameter
    KubernetesInfo kubernetes;
    @Parameter
    List<ReleaseInfo> releases;
    @Parameter(defaultValue="${project.build.directory}/helm-values", readonly=true, required=true)
    File helmValues;
    @Component
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    List<RemoteRepository> remoteRepos;
    Path pwd;
    Path templatePath;
    Path globalValuePath;
    Path globalValuesFile;
    AtomicReference<KubernetesClient> cachedClient = new AtomicReference();

    @Override
    protected void doExecute() throws MojoExecutionException, IOException {
        if (!this.validateConfiguration()) {
            throw new MojoExecutionException("Invalid configuration");
        }
        this.initializeGlobalValuesFiles();
        String globalNamespace = this.kubernetes != null ? this.kubernetes.getNamespace() : null;
        for (ReleaseInfo release : this.getIterable(this.getReleasesInRequiredOrder())) {
            String namespace = release.namespace;
            if (namespace == null) {
                namespace = globalNamespace;
            }
            this.preHelmCommand(release, namespace);
            CommandLineGenerator generator = new CommandLineGenerator(this).globalOptions(this, namespace).releaseOptions(release, this);
            this.executeHelmCommand(generator.getCommand());
            this.postHelmCommand(release, namespace);
        }
    }

    protected void initializeGlobalValuesFiles() throws IOException {
        this.pwd = Path.of("", new String[0]).toAbsolutePath();
        this.templatePath = this.pwd.relativize(Files.createDirectories(this.helmValues.toPath(), new FileAttribute[0]));
        if (this.valueYaml != null) {
            this.globalValuePath = this.releaseValues("_.yaml");
            if (this.globalValuePath != null) {
                Files.writeString(this.globalValuePath, (CharSequence)this.valueYaml, new OpenOption[0]);
            }
        }
        if (this.valuesFile != null && this.releaseValues(this.valuesFile.getName()) != null) {
            if (this.valuesFile.canRead()) {
                this.globalValuesFile = this.pwd.relativize(this.valuesFile.toPath());
            } else {
                this.getLog().info((CharSequence)("Ignoring unreadable values file " + this.valuesFile.getAbsolutePath()));
            }
        }
    }

    protected boolean validateConfiguration() {
        if (this.releases == null) {
            return true;
        }
        long nErrors = this.releases.stream().filter(this::validateRelease).count();
        return nErrors == 0L;
    }

    protected boolean validateRelease(ReleaseInfo release) {
        String chart = release.chart;
        if (chart == null) {
            this.getLog().error((CharSequence)("Missing chart in " + release));
            return true;
        }
        if (release.name == null) {
            release.setName(ReleaseHelper.unversionedName(chart));
        }
        if (ReleaseHelper.isMavenArtifact(chart)) {
            try {
                release.setChart(this.localArtifact(chart));
            }
            catch (ArtifactResolutionException e) {
                this.getLog().error((CharSequence)("Cannot find artifact " + chart));
                return true;
            }
        }
        return false;
    }

    void pumpLog(InputStream is, Consumer<String> lineConsumer) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            reader.lines().forEach(lineConsumer);
        }
        catch (IOException e) {
            lineConsumer.accept(e.getMessage());
        }
    }

    private void executeHelmCommand(List<String> command) throws MojoExecutionException, IOException {
        try {
            this.getLog().info((CharSequence)String.join((CharSequence)" ", command));
            Process process = new ProcessBuilder(command).start();
            ForkJoinPool pool = ForkJoinPool.commonPool();
            pool.execute(() -> this.pumpLog(process.getInputStream(), arg_0 -> ((Log)this.getLog()).info(arg_0)));
            pool.execute(() -> this.pumpLog(process.getErrorStream(), this::logLine));
            if (process.waitFor() != 0) {
                throw new MojoExecutionException("helm exit value: " + process.exitValue());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void logLine(String s) {
        Matcher matcher = WARNING.matcher(s);
        if (matcher.matches()) {
            this.getLog().warn((CharSequence)matcher.group(2));
        } else {
            this.getLog().error((CharSequence)s);
        }
    }

    LinkedList<ReleaseInfo> getReleasesInRequiredOrder() {
        List solved;
        long count;
        if (this.releases == null) {
            return new LinkedList<ReleaseInfo>();
        }
        HashMap<String, ReleaseState> releaseToRequirements = new HashMap<String, ReleaseState>();
        this.releases.forEach(release -> {
            ReleaseState requirements = new ReleaseState((ReleaseInfo)release, ReleaseHelper.asSet(release.requires));
            if (releaseToRequirements.put(release.name, requirements) != null) {
                throw new IllegalStateException("duplicate definition of " + release.name);
            }
        });
        releaseToRequirements.forEach((name, value) -> value.getRequires().forEach(require -> {
            ReleaseState requirements = (ReleaseState)releaseToRequirements.get(require);
            if (requirements == null) {
                throw new IllegalArgumentException("Missing definition for require " + require + " on release " + name);
            }
            requirements.addDependent((String)require, (ReleaseState)value);
        }));
        LinkedList<ReleaseInfo> releaseOrder = new LinkedList<ReleaseInfo>();
        while ((count = (solved = releaseToRequirements.values().stream().filter(ReleaseState::isSolved).collect(Collectors.toList())).stream().filter(requirement -> {
            releaseOrder.add(requirement.getRelease());
            releaseToRequirements.remove(requirement.getRelease().name);
            return requirement.removeRequiresFromDependents();
        }).count()) != 0L) {
        }
        if (!releaseToRequirements.isEmpty()) {
            throw new IllegalArgumentException("Could not determine ordering for releases: " + String.join((CharSequence)", ", releaseToRequirements.keySet()));
        }
        return releaseOrder;
    }

    private String localArtifact(String chart) throws ArtifactResolutionException {
        DefaultArtifact gav = new DefaultArtifact(chart);
        DefaultArtifact chartArtifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), "tgz", gav.getVersion());
        ArtifactRequest request = new ArtifactRequest((Artifact)chartArtifact, this.remoteRepos, null);
        return this.repoSystem.resolveArtifact(this.repoSession, request).getArtifact().getFile().getAbsolutePath();
    }

    protected void preHelmCommand(ReleaseInfo release, String namespace) {
    }

    protected void postHelmCommand(ReleaseInfo release, String namespace) {
    }

    protected KubernetesClient getKubernetesClient() {
        KubernetesClient result = this.cachedClient.get();
        if (result == null) {
            String context;
            KubernetesClientBuilder clientBuilder = new KubernetesClientBuilder();
            KubernetesInfo kubernetesInfo = this.getKubernetes();
            if (kubernetesInfo != null && (context = kubernetesInfo.getContext()) != null) {
                Config config = Config.autoConfigure((String)context);
                clientBuilder.withConfig(config);
            }
            if (!this.cachedClient.compareAndSet(null, result = clientBuilder.build())) {
                return this.cachedClient.get();
            }
        }
        return result;
    }

    @Override
    public String chartReference(ReleaseInfo info) {
        return info.chart;
    }

    @Override
    public void releaseOptions(ReleaseInfo release, List<String> command) throws IOException {
    }

    @Override
    public Iterable<ReleaseInfo> getIterable(LinkedList<ReleaseInfo> inOrder) {
        return inOrder;
    }

    @Override
    public Path releaseValues(String valuesFileName) {
        return this.templatePath.resolve(valuesFileName);
    }

    @Override
    public void createNamespace(List<String> command) {
    }

    @Generated
    public String getValueYaml() {
        return this.valueYaml;
    }

    @Override
    @Generated
    public KubernetesInfo getKubernetes() {
        return this.kubernetes;
    }

    @Override
    @Generated
    public Path getGlobalValuePath() {
        return this.globalValuePath;
    }

    @Override
    @Generated
    public Path getGlobalValuesFile() {
        return this.globalValuesFile;
    }
}

