/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.helmrepo.maven.plugin;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.helmrepo.maven.plugin.HelmRelease;
import org.honton.chas.helmrepo.maven.plugin.PodSelector;
import org.honton.chas.helmrepo.maven.plugin.ReleaseInfo;

@Mojo(name="uninstall", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true)
public class HelmUninstall
extends HelmRelease {
    @Parameter(defaultValue="${project.build.directory}/pod-logs")
    File podLogs;

    @Override
    protected void initializeGlobalValuesFiles() {
        this.pwd = Path.of("", new String[0]).toAbsolutePath();
    }

    @Override
    public void addSubCommand(List<String> commandLine) {
        commandLine.add("uninstall");
    }

    @Override
    public String chartReference(ReleaseInfo info) {
        return null;
    }

    @Override
    public Path releaseValues(String valuesFileName) {
        return null;
    }

    @Override
    public Iterable<ReleaseInfo> getIterable(LinkedList<ReleaseInfo> inOrder) {
        return inOrder::descendingIterator;
    }

    @Override
    protected void preHelmCommand(ReleaseInfo release, String namespace) {
        List<String> logs = release.logs;
        if (logs != null) {
            logs.forEach(ps -> this.saveLogs(PodSelector.of(ps, namespace)));
        } else {
            this.getLog().info((CharSequence)"No Logs specified");
        }
    }

    private void saveLogs(PodSelector selector) {
        long count = this.query(selector).filter(this::savePodLogs).count();
        if (count == 0L) {
            this.getLog().warn((CharSequence)("No pods for " + selector));
        }
    }

    private boolean savePodLogs(PodResource podResource) {
        ObjectMeta meta = ((Pod)podResource.item()).getMetadata();
        Path logDir = this.podLogs.toPath().resolve(meta.getNamespace());
        Path logPath = logDir.resolve(meta.getName() + ".log");
        try {
            Files.createDirectories(logDir, new FileAttribute[0]);
            Files.copy(podResource.getLogInputStream(), logPath, StandardCopyOption.REPLACE_EXISTING);
            this.getLog().info((CharSequence)("Saved " + this.pwd.relativize(logPath)));
            return true;
        }
        catch (IOException ioException) {
            this.getLog().error((CharSequence)("Failed save to " + this.pwd.relativize(logPath)), (Throwable)ioException);
            return false;
        }
    }

    private Stream<PodResource> query(PodSelector selector) {
        MixedOperation pods = this.getKubernetesClient().pods();
        AnyNamespaceOperation ans = selector.getNamespace() != null ? (AnyNamespaceOperation)pods.inNamespace(selector.getNamespace()) : (AnyNamespaceOperation)pods.inAnyNamespace();
        return ans.resources().filter(pr -> ((Pod)pr.item()).getMetadata().getName().startsWith(selector.getPod()));
    }
}

