/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.helmrepo.maven.plugin;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.helmrepo.maven.plugin.HelmRelease;
import org.honton.chas.helmrepo.maven.plugin.ReleaseInfo;
import org.honton.chas.helmrepo.maven.plugin.ServiceSelector;

@Mojo(name="upgrade", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, threadSafe=true)
public class HelmUpgrade
extends HelmRelease {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;

    @Override
    public void addSubCommand(List<String> command) {
        command.add("upgrade");
        command.add("--install");
    }

    @Override
    protected void postHelmCommand(ReleaseInfo release, String namespace) {
        Map<String, String> nodePorts = release.nodePorts;
        if (nodePorts != null) {
            nodePorts.forEach((property, nodePort) -> this.setProperty((String)property, ServiceSelector.of(nodePort, namespace)));
        }
    }

    private void setProperty(String property, ServiceSelector selector) {
        long count = this.findServices(selector).filter(service -> this.setProperty((Service)service, property, selector)).count();
        if (count == 0L) {
            String warning = String.format("Not setting property %s, no matching service port %s", property, selector);
            this.getLog().warn((CharSequence)warning);
        }
    }

    private Stream<Service> findServices(ServiceSelector selector) {
        MixedOperation services = this.getKubernetesClient().services();
        AnyNamespaceOperation ans = selector.getNamespace() != null ? (AnyNamespaceOperation)services.inNamespace(selector.getNamespace()) : (AnyNamespaceOperation)services.inAnyNamespace();
        return ans.resources().filter(pr -> ((Service)pr.item()).getMetadata().getName().equals(selector.getService())).map(Resource::item);
    }

    private boolean setProperty(Service service, String property, ServiceSelector selector) {
        ServicePort servicePort = this.findPort(service, property, selector);
        if (servicePort == null) {
            return false;
        }
        Integer nodePort = servicePort.getNodePort();
        if (nodePort == null) {
            String warning = String.format("Not setting property %s, nodePort not set for portName %s", property, servicePort.getName());
            this.getLog().warn((CharSequence)warning);
            return true;
        }
        this.getLog().info((CharSequence)("Setting " + property + " to " + nodePort));
        this.session.getUserProperties().setProperty(property, nodePort.toString());
        return true;
    }

    private ServicePort findPort(Service service, String property, ServiceSelector selector) {
        String warning;
        ServicePort port;
        List ports = service.getSpec().getPorts();
        if (ports == null || ports.isEmpty()) {
            port = null;
            warning = String.format("Not setting property %s, no ports defined on service %s", property, service.getMetadata().getName());
        } else {
            String portName = selector.getPort();
            if (portName == null) {
                port = (ServicePort)ports.get(0);
                if (ports.size() == 1) {
                    return port;
                }
                warning = String.format("Possible incorrect value for %s, multiple ports defined on service %s and no portName specified; using portName %s", property, service.getMetadata().getName(), port.getName());
            } else {
                Optional<ServicePort> opt = ports.stream().filter(selector::matchesPort).findFirst();
                if (opt.isPresent()) {
                    return opt.get();
                }
                port = null;
                warning = String.format("Not setting property %s, no port defined on service %s with portName %s", property, service.getMetadata().getName(), portName);
            }
        }
        this.getLog().warn((CharSequence)warning);
        return port;
    }

    @Override
    public void releaseOptions(ReleaseInfo release, List<String> command) {
        command.add("--wait");
        if (release.wait != 0L) {
            command.add("--timeout");
            command.add(release.wait + "s");
        }
    }

    @Override
    public void createNamespace(List<String> command) {
        if (this.kubernetes == null || !Boolean.FALSE.equals(this.kubernetes.getCreateNamespace())) {
            command.add("--create-namespace");
        }
    }
}

