/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.helmrepo.maven.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.honton.chas.helmrepo.maven.plugin.ReleaseInfo;

public final class ReleaseState {
    @NonNull
    private final ReleaseInfo release;
    @NonNull
    private final Set<String> requires;
    private final Map<String, ReleaseState> depends = new HashMap<String, ReleaseState>();

    public boolean isSolved() {
        return this.requires.isEmpty();
    }

    boolean removeRequiresFromDependents() {
        long count = this.depends.values().stream().filter(dependent -> dependent.removeRequirement(this.release.name)).count();
        return count > 0L;
    }

    private boolean removeRequirement(String name) {
        this.requires.remove(name);
        return this.requires.isEmpty();
    }

    public void addDependent(String name, ReleaseState value) {
        this.depends.put(name, value);
    }

    @Generated
    public ReleaseState(@NonNull ReleaseInfo release, @NonNull Set<String> requires) {
        if (release == null) {
            throw new NullPointerException("release is marked non-null but is null");
        }
        if (requires == null) {
            throw new NullPointerException("requires is marked non-null but is null");
        }
        this.release = release;
        this.requires = requires;
    }

    @NonNull
    @Generated
    public ReleaseInfo getRelease() {
        return this.release;
    }

    @NonNull
    @Generated
    public Set<String> getRequires() {
        return this.requires;
    }

    @Generated
    public Map<String, ReleaseState> getDepends() {
        return this.depends;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReleaseState)) {
            return false;
        }
        ReleaseState other = (ReleaseState)o;
        ReleaseInfo this$release = this.getRelease();
        ReleaseInfo other$release = other.getRelease();
        if (this$release == null ? other$release != null : !this$release.equals(other$release)) {
            return false;
        }
        Set<String> this$requires = this.getRequires();
        Set<String> other$requires = other.getRequires();
        if (this$requires == null ? other$requires != null : !((Object)this$requires).equals(other$requires)) {
            return false;
        }
        Map<String, ReleaseState> this$depends = this.getDepends();
        Map<String, ReleaseState> other$depends = other.getDepends();
        return !(this$depends == null ? other$depends != null : !((Object)this$depends).equals(other$depends));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ReleaseInfo $release = this.getRelease();
        result = result * 59 + ($release == null ? 43 : $release.hashCode());
        Set<String> $requires = this.getRequires();
        result = result * 59 + ($requires == null ? 43 : ((Object)$requires).hashCode());
        Map<String, ReleaseState> $depends = this.getDepends();
        result = result * 59 + ($depends == null ? 43 : ((Object)$depends).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReleaseState(release=" + this.getRelease() + ", requires=" + this.getRequires() + ", depends=" + this.getDepends() + ")";
    }
}

