/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.helmrepo.maven.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntPredicate;
import lombok.Generated;
import lombok.NonNull;

public final class SemVer {
    private final int major;
    private final int minor;
    private final int patch;
    private final List<String> preRelease;
    private final List<String> build;

    public static SemVer valueOf(String s) {
        return new VersionParser(s).parse();
    }

    @Generated
    public SemVer(int major, int minor, int patch, List<String> preRelease, List<String> build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.build = build;
    }

    @Generated
    public int getMajor() {
        return this.major;
    }

    @Generated
    public int getMinor() {
        return this.minor;
    }

    @Generated
    public int getPatch() {
        return this.patch;
    }

    @Generated
    public List<String> getPreRelease() {
        return this.preRelease;
    }

    @Generated
    public List<String> getBuild() {
        return this.build;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SemVer)) {
            return false;
        }
        SemVer other = (SemVer)o;
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        if (this.getPatch() != other.getPatch()) {
            return false;
        }
        List<String> this$preRelease = this.getPreRelease();
        List<String> other$preRelease = other.getPreRelease();
        if (this$preRelease == null ? other$preRelease != null : !((Object)this$preRelease).equals(other$preRelease)) {
            return false;
        }
        List<String> this$build = this.getBuild();
        List<String> other$build = other.getBuild();
        return !(this$build == null ? other$build != null : !((Object)this$build).equals(other$build));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getPatch();
        List<String> $preRelease = this.getPreRelease();
        result = result * 59 + ($preRelease == null ? 43 : ((Object)$preRelease).hashCode());
        List<String> $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : ((Object)$build).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SemVer(major=" + this.getMajor() + ", minor=" + this.getMinor() + ", patch=" + this.getPatch() + ", preRelease=" + this.getPreRelease() + ", build=" + this.getBuild() + ")";
    }

    static final class VersionParser {
        private final String source;
        private int offset = 0;

        public VersionParser(@NonNull String s) {
            if (s == null) {
                throw new NullPointerException("s is marked non-null but is null");
            }
            this.source = s;
        }

        SemVer parse() {
            int major = this.numeric("major");
            this.consumeDot();
            int minor = this.numeric("minor");
            this.consumeDot();
            int patch = this.numeric("patch");
            List<String> preRelease = this.readSegments(45, true);
            List<String> build = this.readSegments(43, false);
            if (this.offset < this.source.length()) {
                throw new IllegalArgumentException(String.format("Unexpected characters in '%s' at %d", this.source, this.offset - 1));
            }
            return new SemVer(major, minor, patch, preRelease, build);
        }

        private int numeric(String version) {
            String numeric = this.identifier(version, Character::isDigit);
            if (numeric.charAt(0) == '0' && numeric.length() > 1) {
                throw new IllegalArgumentException(String.format("No leading zero allowed in '%s' at position %d", numeric, this.offset - numeric.length()));
            }
            return Integer.parseInt(numeric);
        }

        private List<String> readSegments(int leadChar, boolean preRelease) {
            if (this.peek() != leadChar) {
                return List.of();
            }
            ArrayList<String> segments = new ArrayList<String>();
            do {
                segments.add(this.identifier(preRelease));
            } while (this.peek() == 46);
            return Collections.unmodifiableList(segments);
        }

        private boolean noMoreToProcess() {
            return this.offset >= this.source.length();
        }

        private int peek() {
            if (this.noMoreToProcess()) {
                return -1;
            }
            return this.source.charAt(this.offset);
        }

        private int get() {
            return this.source.charAt(this.offset++);
        }

        private void consumeDot() {
            if (this.noMoreToProcess()) {
                throw new IllegalArgumentException(String.format("Expected '.' in '%s' at position %d", this.source, this.offset - 1));
            }
            int c = this.get();
            if (46 != c) {
                throw new IllegalArgumentException(String.format("Expected '.', got '%c' in '%s' at position %d", c, this.source, this.offset - 1));
            }
        }

        private boolean isIdentifierCharacter(int c) {
            return Character.isDigit(c) || 65 <= c && c <= 90 || 97 <= c && c <= 122 || c == 45;
        }

        private String identifier(boolean preRelease) {
            int toss = this.get();
            if (toss != 43 && toss != 45 && toss != 46) {
                throw new IllegalStateException();
            }
            if (preRelease && Character.isDigit(this.peek())) {
                return this.identifier("numeric", Character::isDigit);
            }
            return this.identifier("alphanumeric", this::isIdentifierCharacter);
        }

        private String identifier(String type, IntPredicate predicate) {
            int start = this.offset;
            while (predicate.test(this.peek())) {
                ++this.offset;
            }
            if (start == this.offset) {
                throw new IllegalArgumentException(String.format("Empty %s identifier '%s' at %d", type, this.source, start));
            }
            return this.source.substring(start, this.offset);
        }
    }
}

