/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.helmrepo.maven.plugin;

import io.fabric8.kubernetes.api.model.ServicePort;
import lombok.Generated;
import lombok.NonNull;

public final class ServiceSelector {
    private final String namespace;
    @NonNull
    private final String service;
    private final String port;

    public static ServiceSelector of(String nsp, String namespace) {
        int slash = nsp.indexOf(47);
        if (slash >= 0) {
            namespace = nsp.substring(0, slash).trim();
        } else if (namespace != null) {
            namespace = namespace.trim();
        }
        int idx = nsp.indexOf(58, ++slash);
        return idx < 0 ? new ServiceSelector(namespace, nsp.substring(slash).trim(), null) : new ServiceSelector(namespace, nsp.substring(slash, idx).trim(), nsp.substring(idx + 1).trim());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.namespace != null) {
            sb.append(this.namespace).append('/');
        }
        sb.append(this.service);
        if (this.port != null) {
            sb.append(':').append(this.port);
        }
        return sb.toString();
    }

    public boolean matchesPort(ServicePort servicePort) {
        if (servicePort.getName() == null && this.port == null) {
            return true;
        }
        if (servicePort.getName().equals(this.port)) {
            return true;
        }
        return this.port != null && servicePort.getPort().toString().equals(this.port);
    }

    @Generated
    public ServiceSelector(String namespace, @NonNull String service, String port) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        this.namespace = namespace;
        this.service = service;
        this.port = port;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @NonNull
    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceSelector)) {
            return false;
        }
        ServiceSelector other = (ServiceSelector)o;
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$service = this.getService();
        String other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        return !(this$port == null ? other$port != null : !this$port.equals(other$port));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        return result;
    }
}

