/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.honton.chas.podman.maven.plugin.RemoteInfo;

public class CommandLineGenerator {
    private final List<String> command = new ArrayList<String>();

    public CommandLineGenerator(RemoteInfo remoteInfo) {
        this.command.add("podman");
        if (remoteInfo != null) {
            String connection;
            String url = remoteInfo.url;
            if (url != null) {
                this.command.add("--url");
                this.command.add(url);
            }
            if ((connection = remoteInfo.connection) != null) {
                this.command.add("--connection");
                this.command.add(connection);
            }
        }
    }

    public void addCmd(String cmd) {
        this.command.add(cmd);
    }

    public void addArgs(Map<String, String> buildArguments) {
        if (buildArguments != null) {
            buildArguments.forEach((k, v) -> {
                this.command.add("--build-arg");
                this.command.add(k + "=" + v);
            });
        }
    }

    public boolean addPlatforms(List<String> platforms) {
        if (platforms != null) {
            LinkedHashSet set = new LinkedHashSet();
            platforms.forEach(p -> Arrays.stream(p.split(",")).map(String::strip).forEach(set::add));
            if (!set.isEmpty()) {
                this.command.add("--platform");
                this.command.add(String.join((CharSequence)",", set));
                return set.size() > 1;
            }
        }
        return false;
    }

    public void addManifest(String name) {
        this.command.add("--manifest");
        this.command.add(name);
    }

    public void addTag(String name) {
        this.command.add("--tag");
        this.command.add(name);
    }

    public void addContainerfile(String containerfile) {
        if (!"Containerfile".equals(containerfile)) {
            this.command.add("--file");
            this.command.add(containerfile);
        }
    }

    public void addContext(Path contextDir) {
        this.command.add("./" + contextDir.toString());
    }

    public List<String> getCommand() {
        return this.command;
    }
}

