/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.podman.maven.plugin.CommandLineGenerator;
import org.honton.chas.podman.maven.plugin.PodmanGoal;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class PodmanBuild
extends PodmanGoal {
    @Parameter(required=true, defaultValue="${project.build.directory}/contextDir")
    File contextDir;
    @Parameter(required=true, defaultValue="Containerfile")
    String containerfile;
    @Parameter
    Map<String, String> buildArguments;
    @Parameter(required=true)
    String name;
    @Parameter
    List<String> platforms;
    @Parameter(defaultValue="false")
    boolean loadIntoDockerImageCache;
    @Parameter(required=true, readonly=true, defaultValue="${project.build.directory}/dockerImage.tar")
    File dockerImageTar;

    @Override
    protected final void doExecute() throws IOException, MojoExecutionException {
        CommandLineGenerator generator = new CommandLineGenerator(this.remote);
        generator.addCmd("build");
        generator.addArgs(this.buildArguments);
        if (generator.addPlatforms(this.platforms)) {
            generator.addManifest(this.name);
        } else {
            generator.addTag(this.name);
        }
        generator.addContainerfile(this.containerfile);
        generator.addContext(this.pwd.relativize(this.contextDir.toPath()));
        this.executeCommand(generator.getCommand());
        if (this.loadIntoDockerImageCache) {
            this.loadImage();
        }
    }

    private void loadImage() throws IOException, MojoExecutionException {
        CommandLineGenerator generator = new CommandLineGenerator(this.remote);
        generator.addCmd("save");
        generator.addCmd("--output");
        Path path = this.dockerImageTar.toPath();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        String tarLocation = this.pwd.relativize(path).toString();
        generator.addCmd(tarLocation);
        generator.addCmd(this.name);
        this.executeCommand(generator.getCommand());
        this.executeCommand(List.of("docker", "load", "-i", tarLocation));
    }
}

