/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.podman.maven.plugin.RemoteInfo;

public abstract class PodmanGoal
extends AbstractMojo {
    private static final Pattern WARNING = Pattern.compile("\\[?(warning)]?:? ?(.+)", 2);
    private static final Pattern ERROR = Pattern.compile("\\[?(error)]?:? ?(.+)", 2);
    @Parameter(property="podman.skip", defaultValue="false")
    boolean skip;
    @Parameter(property="remote")
    RemoteInfo remote;
    Path pwd;

    public final void execute() throws MojoFailureException, MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping podman");
        } else {
            try {
                this.pwd = Path.of("", new String[0]).toAbsolutePath();
                this.doExecute();
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, IOException;

    void pumpLog(InputStream is, Consumer<String> lineConsumer) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            reader.lines().forEach(lineConsumer);
        }
        catch (IOException e) {
            lineConsumer.accept(e.getMessage());
        }
    }

    void executeCommand(List<String> command) throws MojoExecutionException, IOException {
        try {
            this.getLog().info((CharSequence)String.join((CharSequence)" ", command));
            Process process = new ProcessBuilder(command).start();
            ForkJoinPool pool = ForkJoinPool.commonPool();
            pool.execute(() -> this.pumpLog(process.getInputStream(), arg_0 -> ((Log)this.getLog()).info(arg_0)));
            pool.execute(() -> this.pumpLog(process.getErrorStream(), this::logLine));
            if (process.waitFor() != 0) {
                throw new MojoExecutionException("helm exit value: " + process.exitValue());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void logLine(String s) {
        Matcher error = ERROR.matcher(s);
        if (error.matches()) {
            this.getLog().error((CharSequence)error.group(2));
        } else {
            Matcher warning = WARNING.matcher(s);
            if (warning.matches()) {
                this.getLog().warn((CharSequence)warning.group(2));
            } else {
                this.getLog().info((CharSequence)s);
            }
        }
    }
}

