/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.honton.chas.podman.maven.plugin.RemoteInfo;

public class CommandLineGenerator {
    private final List<String> command = new ArrayList<String>();

    public CommandLineGenerator(RemoteInfo remoteInfo) {
        this.command.add("podman");
        if (remoteInfo != null) {
            String connection;
            String url = remoteInfo.url;
            if (url != null) {
                this.command.add("--url");
                this.command.add(url);
            }
            if ((connection = remoteInfo.connection) != null) {
                this.command.add("--connection");
                this.command.add(connection);
            }
        }
    }

    public CommandLineGenerator addCmd(String cmd) {
        this.command.add(cmd);
        return this;
    }

    public CommandLineGenerator addParameter(String parameter) {
        this.command.add(parameter);
        return this;
    }

    public CommandLineGenerator addArgs(Map<String, String> buildArguments) {
        if (buildArguments != null) {
            buildArguments.forEach((k, v) -> {
                this.command.add("--build-arg");
                this.command.add(k + "=" + v);
            });
        }
        return this;
    }

    private boolean addPlatforms(List<String> platforms) {
        if (platforms != null) {
            LinkedHashSet set = new LinkedHashSet();
            platforms.forEach(p -> Arrays.stream(p.split(",")).map(String::strip).forEach(set::add));
            if (!set.isEmpty()) {
                this.command.add("--platform");
                this.command.add(String.join((CharSequence)",", set));
                return set.size() > 1;
            }
        }
        return false;
    }

    public CommandLineGenerator addPlatformAndImage(List<String> platforms, String image) {
        if (this.addPlatforms(platforms)) {
            this.command.add("--manifest");
        } else {
            this.command.add("--tag");
        }
        this.command.add(image);
        return this;
    }

    public CommandLineGenerator addContainerfile(String containerfile) {
        if (!"Containerfile".equals(containerfile)) {
            this.command.add("--file");
            this.command.add(containerfile);
        }
        return this;
    }

    public CommandLineGenerator addContext(Path contextDir) {
        this.command.add("./" + contextDir.toString());
        return this;
    }

    public List<String> getCommand() {
        return this.command;
    }
}

