/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.podman.maven.plugin.CommandLineGenerator;
import org.honton.chas.podman.maven.plugin.RemoteInfo;

public abstract class PodmanGoal
extends AbstractMojo {
    private static final Pattern WARNING = Pattern.compile("\\[?(warning)]?:? ?(.+)", 2);
    @Parameter(property="podman.skip", defaultValue="false")
    boolean skip;
    @Parameter(property="remote")
    RemoteInfo remote;
    Path pwd;

    public final void execute() throws MojoFailureException, MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping podman");
        } else {
            try {
                this.pwd = Path.of("", new String[0]).toAbsolutePath();
                this.doExecute();
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, IOException;

    void pumpLog(InputStream is, Consumer<String> lineConsumer) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            reader.lines().forEach(lineConsumer);
        }
        catch (IOException e) {
            lineConsumer.accept(e.getMessage());
        }
    }

    void executeCommand(CommandLineGenerator generator) throws MojoExecutionException, IOException {
        this.executeCommand(generator.getCommand(), null);
    }

    void executeCommand(List<String> command, String stdin) throws MojoExecutionException, IOException {
        this.getLog().info((CharSequence)String.join((CharSequence)" ", command));
        Process process = new ProcessBuilder(command).start();
        ForkJoinPool pool = ForkJoinPool.commonPool();
        pool.execute(() -> this.pumpLog(process.getInputStream(), arg_0 -> ((Log)this.getLog()).info(arg_0)));
        pool.execute(() -> this.pumpLog(process.getErrorStream(), this::errorLine));
        OutputStream os = process.getOutputStream();
        if (stdin != null) {
            os.write(stdin.getBytes(StandardCharsets.UTF_8));
        }
        os.close();
        try {
            if (process.waitFor() != 0) {
                throw new MojoExecutionException("podman exit value: " + process.exitValue());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void errorLine(String s) {
        Matcher warning = WARNING.matcher(s);
        if (warning.matches()) {
            this.getLog().warn((CharSequence)warning.group(2));
        } else {
            this.getLog().info((CharSequence)s);
        }
    }
}

