/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.podman.maven.plugin.CommandLineGenerator;
import org.honton.chas.podman.maven.plugin.PodmanGoal;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class PodmanBuild
extends PodmanGoal {
    @Parameter(required=true, defaultValue="${project.build.directory}/contextDir")
    File contextDir;
    @Parameter(required=true, defaultValue="Containerfile")
    String containerfile;
    @Parameter
    Map<String, String> buildArguments;
    @Parameter(required=true)
    String image;
    @Parameter
    List<String> platforms;
    @Parameter(defaultValue="false")
    boolean loadDockerCache;
    @Parameter(required=true, readonly=true, defaultValue="${project.build.directory}/dockerImage.tar")
    File dockerImageTar;

    @Override
    protected final void doExecute() throws IOException, MojoExecutionException {
        this.executeCommand(new CommandLineGenerator(this).addCmd("build").addArgs(this.buildArguments).addPlatformAndImage(this.platforms, this.image).addContainerfile(this.containerfile).addContext(this.pwd.relativize(this.contextDir.toPath())));
        if (this.loadDockerCache) {
            this.loadImage();
        }
    }

    private void loadImage() throws IOException, MojoExecutionException {
        Path path = this.dockerImageTar.toPath();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        String tarLocation = this.pwd.relativize(path).toString();
        this.executeCommand(new CommandLineGenerator(this).addCmd("save").addParameter("--output").addParameter(tarLocation).addParameter(this.image));
        this.executeCommand(List.of("docker", "load", "-i", tarLocation), null);
    }
}

