/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.honton.chas.podman.maven.plugin.CommandLineGenerator;
import org.honton.chas.podman.maven.plugin.PodmanGoal;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="login", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class PodmanLogin
extends PodmanGoal {
    @Parameter(required=true)
    String registry;
    @Parameter
    String username;
    @Parameter
    String password;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;

    @Override
    protected final void doExecute() throws IOException, MojoExecutionException {
        Server server = this.getAuthInfo();
        List<String> command = new CommandLineGenerator(this).addCmd("login").addParameter("--username").addParameter(server.getUsername()).addParameter("--password-stdin").addParameter(this.registry).getCommand();
        this.executeCommand(command, server.getPassword());
    }

    private Server getAuthInfo() throws MojoExecutionException {
        Server server = this.settings.getServer(this.registry);
        if (server == null) {
            this.getLog().info((CharSequence)("No credentials for " + this.registry + " in settings.xml"));
            server = new Server();
        }
        this.ensure(() -> ((Server)server).getUsername(), arg_0 -> ((Server)server).setUsername(arg_0), this.username);
        if (this.ensure(() -> ((Server)server).getPassword(), arg_0 -> ((Server)server).setPassword(arg_0), this.password)) {
            if (this.securityDispatcher instanceof DefaultSecDispatcher) {
                ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile("~/.m2/settings-security.xml");
            }
            try {
                server.setPassword(this.securityDispatcher.decrypt(server.getPassword()));
            }
            catch (SecDispatcherException e) {
                throw new MojoExecutionException("unable to decrypt password for " + this.registry, (Exception)((Object)e));
            }
        }
        return server;
    }

    private <T> boolean ensure(Supplier<T> getter, Consumer<T> setter, T fallback) throws MojoExecutionException {
        if (getter.get() != null) {
            return true;
        }
        if (fallback == null) {
            throw new MojoExecutionException("Missing username or password for " + this.registry);
        }
        setter.accept(fallback);
        return false;
    }
}

