/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.podman.maven.plugin.cmdline.CommandLine;

public abstract class PodmanGoal
extends AbstractMojo {
    private static final Pattern WARNING = Pattern.compile("\\[?(warning)]?:? ?(.+)", 2);
    private static final Pattern ERROR = Pattern.compile("\\[?(error)]?:? ?(.+)", 2);
    @Parameter(property="podman.skip", defaultValue="false")
    boolean skip;
    @Parameter
    public String url;
    @Parameter
    public String connection;
    protected Path pwd;
    protected StringBuilder errorOutput;
    private AtomicReference<ExecutorService> executor = new AtomicReference();

    public final void execute() throws MojoFailureException, MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping podman");
        } else {
            try {
                this.pwd = Path.of("", new String[0]).toAbsolutePath();
                this.doExecute();
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected ExecutorService getExecutor() {
        ExecutorService foo = this.executor.get();
        if (foo == null) {
            ExecutorService pool = Executors.newCachedThreadPool();
            foo = this.executor.compareAndSet(null, pool) ? pool : this.executor.get();
        }
        return foo;
    }

    protected abstract void doExecute() throws MojoExecutionException, IOException;

    void pumpLog(InputStream is, BiConsumer<Integer, String> lineConsumer) {
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(is, StandardCharsets.UTF_8), 128);){
            String line;
            while ((line = reader.readLine()) != null) {
                lineConsumer.accept(reader.getLineNumber(), line);
            }
        }
        catch (IOException e) {
            lineConsumer.accept(-1, e.getMessage());
        }
    }

    private void throwException(int exitCode) {
        if (exitCode != 0) {
            throw new MojoExecutionException("podman exit value: " + exitCode);
        }
    }

    public void executeCommand(CommandLine generator) throws MojoExecutionException, IOException {
        this.executeCommand(generator.getCommand());
    }

    protected void executeCommand(List<String> command) throws MojoExecutionException, IOException {
        this.executeCommand(command, null);
    }

    protected void executeCommand(List<String> command, String stdin) throws MojoExecutionException, IOException {
        this.executeCommand(command, stdin, this::infoLine, this::errorLine, this::throwException);
    }

    protected void createProcess(CommandLine generator, BiConsumer<Integer, String> filter) throws IOException {
        this.createProcess(generator.getCommand(), null, filter, filter);
    }

    protected void executeCommand(CommandLine generator, IntConsumer exitCode) throws MojoExecutionException, IOException {
        this.executeCommand(generator.getCommand(), null, this::infoLine, this::errorLine, exitCode);
    }

    protected void executeCommand(List<String> command, String stdin, BiConsumer<Integer, String> stdout, BiConsumer<Integer, String> stderr, IntConsumer exitCode) throws MojoExecutionException, IOException {
        this.waitForProcess(exitCode, this.createProcess(command, stdin, stdout, stderr));
    }

    protected Process createProcess(List<String> command, String stdin, BiConsumer<Integer, String> stdout, BiConsumer<Integer, String> stderr) throws IOException {
        this.getLog().info((CharSequence)String.join((CharSequence)" ", command));
        this.errorOutput = new StringBuilder();
        ExecutorService pool = this.getExecutor();
        Process process = new ProcessBuilder(command).start();
        pool.execute(() -> this.pumpLog(process.getInputStream(), stdout));
        pool.execute(() -> this.pumpLog(process.getErrorStream(), stderr));
        OutputStream os = process.getOutputStream();
        if (stdin != null) {
            os.write(stdin.getBytes(StandardCharsets.UTF_8));
        }
        os.close();
        return process;
    }

    private void waitForProcess(IntConsumer exitCode, Process process) throws MojoExecutionException {
        try {
            exitCode.accept(process.waitFor());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void infoLine(Integer lineNo, String lineText) {
        if (this.getLog().isDebugEnabled()) {
            lineText = lineNo + 58 + (String)lineText;
        }
        this.getLog().info((CharSequence)lineText);
    }

    private void errorLine(Integer lineNo, String lineText) {
        this.errorOutput.append((String)lineText);
        Matcher warning = WARNING.matcher((CharSequence)lineText);
        if (warning.matches()) {
            this.getLog().warn((CharSequence)warning.group(2));
        } else {
            Matcher error = ERROR.matcher((CharSequence)lineText);
            if (error.matches()) {
                this.getLog().error((CharSequence)error.group(2));
            } else {
                if (this.getLog().isDebugEnabled()) {
                    lineText = lineNo + 58 + (String)lineText;
                }
                this.getLog().info((CharSequence)lineText);
            }
        }
    }
}

