/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin.cmdline;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.honton.chas.podman.maven.plugin.build.PodmanBuild;
import org.honton.chas.podman.maven.plugin.cmdline.CommandLine;

public class BuildCommandLine
extends CommandLine {
    public BuildCommandLine(PodmanBuild goal) {
        super(goal);
        this.addCmd("build");
    }

    public BuildCommandLine addArgs(Map<String, String> buildArguments) {
        if (buildArguments != null) {
            buildArguments.forEach((k, v) -> {
                this.command.add("--build-arg");
                this.command.add(k + "=" + v);
            });
        }
        return this;
    }

    private boolean addPlatforms(List<String> platforms) {
        if (platforms != null) {
            LinkedHashSet set = new LinkedHashSet();
            platforms.forEach(p -> Arrays.stream(p.split(",")).map(String::strip).forEach(set::add));
            if (!set.isEmpty()) {
                this.command.add("--platform");
                this.command.add(String.join((CharSequence)",", set));
                return set.size() > 1;
            }
        }
        return false;
    }

    public BuildCommandLine addPlatformAndImage(List<String> platforms, String image) {
        if (this.addPlatforms(platforms)) {
            this.command.add("--manifest");
        } else {
            this.command.add("--tag");
        }
        this.command.add(image);
        return this;
    }

    public BuildCommandLine addContainerfile(String containerfile) {
        if (!"Containerfile".equals(containerfile)) {
            this.command.add("--file");
            this.command.add(containerfile);
        }
        return this;
    }

    public BuildCommandLine addContext(Path contextDir) {
        this.command.add("./" + contextDir.toString());
        return this;
    }
}

