/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.honton.chas.podman.maven.plugin.config.ContainerConfig;

final class ContainerConfigHelper {
    public static List<ContainerConfig> order(Map<String, ContainerConfig> containers, Log log) throws MojoExecutionException {
        if (containers == null) {
            return List.of();
        }
        AtomicBoolean failed = new AtomicBoolean();
        HashMap<String, RequirementsNode> aliasToNode = new HashMap<String, RequirementsNode>();
        containers.forEach((alias, containerConfig) -> {
            if (containerConfig == null) {
                log.error((CharSequence)("container " + alias + " is misconfigured"));
                failed.set(true);
            } else {
                containerConfig.alias = alias;
                if (containerConfig.name == null) {
                    containerConfig.name = alias;
                }
                aliasToNode.put((String)alias, new RequirementsNode((String)alias, (ContainerConfig)containerConfig));
            }
        });
        if (failed.get()) {
            throw new MojoExecutionException("containers mis-configured");
        }
        aliasToNode.forEach((alias, node) -> node.requires.forEach(require -> {
            RequirementsNode requirements = (RequirementsNode)aliasToNode.get(require);
            if (requirements == null) {
                throw new IllegalArgumentException("Missing definition for require " + require + " on release " + alias);
            }
            requirements.addDependent((String)require, (RequirementsNode)node);
        }));
        ArrayList<ContainerConfig> releaseOrder = new ArrayList<ContainerConfig>();
        while (!aliasToNode.isEmpty()) {
            List<RequirementsNode> solved = aliasToNode.values().stream().filter(RequirementsNode::isSolved).collect(Collectors.toList());
            if (log.isDebugEnabled()) {
                solved.forEach(node -> log.debug((CharSequence)("Solved: " + node)));
            }
            if (solved.isEmpty()) {
                throw new IllegalArgumentException("Could not determine container ordering for: " + String.join((CharSequence)", ", aliasToNode.keySet()));
            }
            solved.forEach(requirement -> {
                releaseOrder.add(requirement.containerConfig);
                aliasToNode.remove(requirement.alias);
                requirement.removeRequiresFromDependents();
            });
        }
        return releaseOrder;
    }

    private ContainerConfigHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class RequirementsNode {
        final String alias;
        final ContainerConfig containerConfig;
        final Set<String> requires;
        final Map<String, RequirementsNode> depends;

        public RequirementsNode(String alias, ContainerConfig containerConfig) {
            this.alias = alias;
            this.containerConfig = containerConfig;
            this.requires = RequirementsNode.asSet(containerConfig.requires);
            this.depends = new HashMap<String, RequirementsNode>();
        }

        private static Set<String> asSet(String commaSeparated) {
            return commaSeparated == null ? Set.of() : Arrays.stream(commaSeparated.split(",")).map(String::strip).collect(Collectors.toSet());
        }

        public boolean isSolved() {
            return this.requires.isEmpty();
        }

        void removeRequiresFromDependents() {
            this.depends.values().forEach(dependent -> dependent.removeRequirement(this.alias));
        }

        private void removeRequirement(String name) {
            this.requires.remove(name);
        }

        public void addDependent(String name, RequirementsNode value) {
            this.depends.put(name, value);
        }

        public String toString() {
            return "ContainerConfigHelper.RequirementsNode(alias=" + this.alias + ", requires=" + this.requires + ")";
        }
    }
}

