/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin.container;

import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.maven.plugin.MojoExecutionException;
import org.honton.chas.podman.maven.plugin.cmdline.CommandLine;
import org.honton.chas.podman.maven.plugin.config.BindMountConfig;
import org.honton.chas.podman.maven.plugin.config.ContainerConfig;
import org.honton.chas.podman.maven.plugin.config.DeviceMountConfig;
import org.honton.chas.podman.maven.plugin.config.TempFsMountConfig;
import org.honton.chas.podman.maven.plugin.config.VolumeMountConfig;
import org.honton.chas.podman.maven.plugin.container.PodmanContainerRun;

class ContainerRunCommandLine
extends CommandLine {
    private final ContainerConfig containerConfig;
    private final PodmanContainerRun goal;

    ContainerRunCommandLine(PodmanContainerRun goal, ContainerConfig containerConfig) {
        super(goal);
        this.addCmd("container");
        this.addCmd("run");
        this.addParameter("--detach");
        this.containerConfig = containerConfig;
        this.goal = goal;
    }

    public static Set<PosixFilePermission> posixFilePermissions(String permissions) {
        int mode = Integer.parseInt(permissions, 8);
        EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
        int i = PosixFilePermission.values().length - 1;
        while (mode != 0) {
            if ((mode & 1) != 0) {
                perms.add(PosixFilePermission.values()[i]);
            }
            mode >>>= 1;
            --i;
        }
        return perms;
    }

    ContainerRunCommandLine addContainerName() {
        this.addParameter("--name");
        this.addParameter(this.containerConfig.name);
        if (!this.containerConfig.alias.equalsIgnoreCase(this.containerConfig.name)) {
            this.addParameter("--network-alias");
            this.addParameter(this.containerConfig.alias);
        }
        return this;
    }

    ContainerRunCommandLine addContainerCmd() throws MojoExecutionException {
        if (this.containerConfig.image == null) {
            throw new MojoExecutionException("Missing image for container " + this.containerConfig.alias);
        }
        this.addParameter(this.containerConfig.image);
        if (this.containerConfig.cmd != null) {
            this.addParameter(this.containerConfig.cmd);
        }
        if (this.containerConfig.args != null) {
            this.containerConfig.args.forEach(this::addParameter);
        }
        return this;
    }

    ContainerRunCommandLine addContainerOptions(String network) {
        this.addParameter("--network").addParameter(network);
        if (this.containerConfig.memory != null) {
            this.addParameter("--memory").addParameter(this.containerConfig.memory);
        }
        if (this.containerConfig.memorySwap != null) {
            this.addParameter("--memory-swap").addParameter(this.containerConfig.memorySwap);
        }
        if (this.containerConfig.entrypoint != null) {
            this.addParameter("--entrypoint").addParameter(this.containerConfig.entrypoint);
        }
        return this;
    }

    ContainerRunCommandLine addEnvironment(Consumer<String> warn) {
        if (this.containerConfig.envFile != null) {
            if (Files.isReadable(Path.of(this.containerConfig.envFile, new String[0]))) {
                this.addParameter("--env-file").addParameter(this.containerConfig.envFile);
            } else {
                warn.accept("ignoring env file " + this.containerConfig.envFile);
            }
        }
        if (this.containerConfig.env != null) {
            this.containerConfig.env.forEach((k, v) -> this.addParameter("--env").addParameter(k + "=" + v));
        }
        return this;
    }

    private static String getMountOptions(DeviceMountConfig config) {
        StringBuilder options = new StringBuilder();
        if (config.read != Boolean.FALSE) {
            options.append("r");
        }
        if (config.write != Boolean.FALSE) {
            options.append("w");
        }
        if (config.mknod != Boolean.FALSE) {
            options.append("m");
        }
        return options.toString();
    }

    public ContainerRunCommandLine addDevices(List<DeviceMountConfig> devices) {
        if (devices != null) {
            for (DeviceMountConfig config : devices) {
                String ops;
                boolean needOpts;
                StringBuilder sb = new StringBuilder().append(config.source);
                if (config.destination != null && !config.destination.equals(config.source)) {
                    sb.append(':').append(config.destination);
                }
                boolean bl = needOpts = !(ops = ContainerRunCommandLine.getMountOptions(config)).equals("rwm");
                if (needOpts) {
                    sb.append(':').append(ops);
                }
                this.addParameter("--device").addParameter(sb.toString());
            }
        }
        return this;
    }

    ContainerRunCommandLine addMounts() throws IOException {
        if (this.containerConfig.mounts != null) {
            this.addBinds(this.containerConfig.mounts.binds);
            this.addTemps(this.containerConfig.mounts.temps);
            this.addVolumes(this.containerConfig.mounts.volumes);
        }
        return this;
    }

    private void addTemps(List<TempFsMountConfig> temps) {
        if (temps != null) {
            temps.forEach(this::addTempFs);
        }
    }

    private void addTempFs(TempFsMountConfig tempFsMount) {
        this.addParameter("--tempfs").addParameter(tempFsMount.destination);
    }

    private void addBinds(List<BindMountConfig> binds) throws IOException {
        if (binds != null) {
            for (BindMountConfig bindMount : binds) {
                Path path = Path.of(bindMount.source, new String[0]);
                if (Files.notExists(path, new LinkOption[0])) {
                    ContainerRunCommandLine.createDirs(path, this.getFileAttributes(bindMount.permissions));
                }
                StringBuilder sb = new StringBuilder().append(bindMount.source).append(':').append(bindMount.destination);
                if (bindMount.readonly) {
                    sb.append(":ro");
                }
                this.addParameter("--volume").addParameter(sb.toString());
            }
        }
    }

    private static void createDirs(Path path, Set<PosixFilePermission> fileAttributes) throws IOException {
        Path parent = path.getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            ContainerRunCommandLine.createDirs(parent, fileAttributes);
        }
        Files.createDirectory(path, new FileAttribute[0]);
        if (!fileAttributes.isEmpty()) {
            Files.setPosixFilePermissions(path, fileAttributes);
        }
    }

    private Set<PosixFilePermission> getFileAttributes(String permissions) {
        if (permissions == null) {
            return Set.of();
        }
        if (permissions.length() == 9) {
            return PosixFilePermissions.fromString(permissions);
        }
        return ContainerRunCommandLine.posixFilePermissions(permissions);
    }

    private void addVolumes(List<VolumeMountConfig> volumes) {
        if (volumes != null) {
            for (VolumeMountConfig volumeMount : volumes) {
                StringBuilder sb = new StringBuilder().append(volumeMount.source).append(':').append(volumeMount.destination);
                if (volumeMount.readonly) {
                    sb.append(":ro");
                }
                this.addParameter("--volume").addParameter(sb.toString());
            }
        }
    }

    ContainerRunCommandLine addPorts() {
        if (this.containerConfig.ports != null) {
            this.containerConfig.ports.forEach(this::addPort);
        }
        return this;
    }

    private void addPort(String mavenPropertyName, Integer containerPort) {
        String hostPortAndInterface = this.goal.lookupProperty(mavenPropertyName);
        if (hostPortAndInterface == null) {
            hostPortAndInterface = this.allocatePort();
            this.goal.setProperty(mavenPropertyName, hostPortAndInterface);
        }
        this.addParameter("--publish").addParameter(hostPortAndInterface + ":" + containerPort);
    }

    private String allocatePort() {
        String string;
        try (ServerSocket serverSocket = new ServerSocket(0);){
            string = Integer.toString(serverSocket.getLocalPort());
        }
        return string;
    }
}

