/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin.container;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.honton.chas.podman.maven.plugin.config.ContainerConfig;
import org.honton.chas.podman.maven.plugin.container.ContainerRmCommandLine;
import org.honton.chas.podman.maven.plugin.container.NetworkCommandLine;
import org.honton.chas.podman.maven.plugin.container.PodmanContainer;

@Mojo(name="container-rm", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true)
public class PodmanContainerRm
extends PodmanContainer {
    @Override
    protected void doExecute(List<ContainerConfig> containerConfigs, String networkName) throws IOException, MojoExecutionException {
        ListIterator<ContainerConfig> li = containerConfigs.listIterator(containerConfigs.size());
        while (li.hasPrevious()) {
            this.rmContainer(li.previous());
        }
        this.rmNetwork(networkName);
    }

    private void rmNetwork(String networkName) {
        NetworkCommandLine cmdLine = new NetworkCommandLine(this);
        cmdLine.addCmd("rm");
        cmdLine.addParameter(networkName);
        this.executeCommand(cmdLine);
    }

    private void rmContainer(ContainerConfig containerConfig) {
        this.executeCommand(new ContainerRmCommandLine(this, containerConfig));
    }
}

