/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.podman.maven.plugin.container;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.honton.chas.podman.maven.plugin.config.ContainerConfig;
import org.honton.chas.podman.maven.plugin.config.HttpWaitConfig;
import org.honton.chas.podman.maven.plugin.config.LogConfig;
import org.honton.chas.podman.maven.plugin.config.WaitConfig;
import org.honton.chas.podman.maven.plugin.container.ContainerRunCommandLine;
import org.honton.chas.podman.maven.plugin.container.LogsCommandLine;
import org.honton.chas.podman.maven.plugin.container.NetworkCommandLine;
import org.honton.chas.podman.maven.plugin.container.PodmanContainer;

@Mojo(name="container-run", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, threadSafe=true)
public class PodmanContainerRun
extends PodmanContainer {
    private BiConsumer<Integer, String> createConsumer(BufferedWriter writer, String alias, Consumer<String> matcher) {
        return (n, line) -> {
            try {
                Log log = this.getLog();
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)(alias + "(" + n + "): " + line));
                }
                matcher.accept((String)line);
                writer.append((CharSequence)line);
                writer.newLine();
                writer.flush();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @Override
    protected void doExecute(List<ContainerConfig> containerConfigs, String networkName) throws IOException, MojoExecutionException {
        this.createNetwork(networkName);
        containerConfigs.forEach(containerConfig -> this.runContainer((ContainerConfig)containerConfig, networkName));
    }

    private void createNetwork(String networkName) {
        NetworkCommandLine cmdLine = new NetworkCommandLine(this);
        cmdLine.addCmd("create");
        if (this.network != null && this.network.driver != null) {
            cmdLine.addParameter("--driver").addParameter(this.network.driver);
        }
        cmdLine.addParameter(networkName);
        this.executeCommand(cmdLine, this::checkExists);
    }

    void checkExists(int exitCode) {
        if (exitCode != 0 && !this.errorOutput.toString().contains("network already exists")) {
            throw new MojoExecutionException("podman exit value: " + exitCode);
        }
    }

    private void runContainer(ContainerConfig containerConfig, String networkName) {
        this.executeCommand(new ContainerRunCommandLine(this, containerConfig).addContainerName().addContainerOptions(networkName).addEnvironment(arg_0 -> ((Log)this.getLog()).warn(arg_0)).addDevices(this.devices).addMounts().addPorts().addContainerCmd());
        CountDownLatch logFragmentWait = this.startLogSpooler(containerConfig);
        this.waitForStartup(containerConfig.wait, logFragmentWait);
    }

    public String lookupProperty(String mavenPropertyName) {
        return this.project.getProperties().getProperty(mavenPropertyName);
    }

    public void setProperty(String mavenPropertyName, String mavenPropertyValue) {
        this.getLog().info((CharSequence)("Setting " + mavenPropertyName + " to " + mavenPropertyValue));
        this.project.getProperties().setProperty(mavenPropertyName, mavenPropertyValue);
    }

    private CountDownLatch startLogSpooler(ContainerConfig containerConfig) throws IOException, MojoExecutionException {
        WaitConfig waitConfig = containerConfig.wait;
        boolean logWait = waitConfig != null && waitConfig.log != null;
        CountDownLatch logDone = logWait ? new CountDownLatch(1) : null;
        Consumer<String> matcher = logWait ? line -> {
            if (line.contains(waitConfig.log)) {
                logDone.countDown();
            }
        } : line -> {};
        LogConfig logConfig = containerConfig.log;
        if (logWait && logConfig == null) {
            logConfig = new LogConfig();
        }
        if (logConfig != null) {
            Path path = logConfig.file != null ? Path.of(logConfig.file, new String[0]) : this.pwd.relativize(this.project.getBasedir().toPath().resolve(Path.of("target", "podman", containerConfig.alias + ".log")));
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            this.createProcess(new LogsCommandLine(this, logConfig, containerConfig.name), this.createConsumer(Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE), containerConfig.alias, matcher));
        }
        return logDone;
    }

    private void waitForStartup(WaitConfig waitConfig, CountDownLatch logFragmentWait) throws MojoExecutionException, IOException, InterpolationException {
        if (waitConfig != null) {
            int time = waitConfig.time != 0 ? waitConfig.time : 60;
            long startTime = System.currentTimeMillis();
            long endTime = startTime + TimeUnit.SECONDS.toMillis(time);
            this.getLog().debug((CharSequence)("start:" + startTime + ", end: " + endTime));
            try {
                this.waitForLog(waitConfig, logFragmentWait, endTime);
                this.waitForHttp(waitConfig.http, endTime);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new MojoExecutionException("interrupted", (Exception)ie);
            }
        }
    }

    private void waitForLog(WaitConfig waitConfig, CountDownLatch logFragmentWait, long endTime) throws InterruptedException, MojoExecutionException {
        if (logFragmentWait != null && !logFragmentWait.await(endTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) {
            throw new MojoExecutionException("Did not see '" + waitConfig.log + "' in log");
        }
    }

    private void waitForHttp(HttpWaitConfig waitConfig, long endTime) throws InterruptedException, IOException, InterpolationException {
        if (waitConfig != null) {
            HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(10L)).build();
            URI uri = URI.create(this.createInterpolator().interpolate(waitConfig.url));
            String method = waitConfig.method != null ? waitConfig.method : "GET";
            int status = waitConfig.status != 0 ? waitConfig.status : 200;
            int interval = waitConfig.interval != 0 ? waitConfig.interval : 15;
            while (true) {
                HttpRequest request = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofMillis(endTime - System.currentTimeMillis())).header("Accept", "*/*").method(method, HttpRequest.BodyPublishers.noBody()).build();
                try {
                    HttpResponse<byte[]> resp = client.send(request, HttpResponse.BodyHandlers.ofByteArray());
                    if (resp.statusCode() == status) {
                        this.getLog().debug((CharSequence)(method + " " + uri + " => " + resp.statusCode()));
                        return;
                    }
                }
                catch (IOException ex) {
                    this.getLog().debug((CharSequence)(method + " " + uri + " => " + ex.getMessage()));
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(interval));
            }
        }
    }

    private Interpolator createInterpolator() {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setEscapeString("\\");
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(this.project.getProperties()));
        return interpolator;
    }
}

