/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.process.exec.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.honton.chas.process.exec.maven.plugin.HealthCheckUrl;

public abstract class AbstractProcessMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter(property="exec.arguments")
    protected List<String> arguments;
    @Parameter(property="exec.environment")
    protected Map<String, String> environment;
    @Parameter(property="exec.workingDir")
    protected String workingDir;
    @Parameter(property="exec.name")
    protected String name;
    @Parameter(defaultValue="${exec.healthCheckUrl}")
    protected HealthCheckUrl healthCheckUrl;
    @Parameter(property="exec.healthCheckValidateSsl", defaultValue="true")
    protected boolean healthCheckValidateSsl;
    @Parameter(property="exec.waitAfterLaunch", required=false, defaultValue="30")
    protected int waitAfterLaunch;
    @Parameter(defaultValue="false", property="exec.waitForInterrupt")
    protected boolean waitForInterrupt;
    @Parameter(required=false, property="exec.processLogFile")
    protected String processLogFile;
    @Parameter(defaultValue="false", property="exec.skip")
    protected boolean skip;

    public void setHealthCheckUrl(String url) throws MalformedURLException {
        this.healthCheckUrl = new HealthCheckUrl();
        this.healthCheckUrl.setUrl(url);
    }

    static File ensureDirectory(File dir) throws IOException {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new IOException("couldn't create directories: " + dir);
        }
        return dir;
    }

    protected void sleepUntilInterrupted() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Hit ENTER on the console to continue the build.");
        try {
            int ch;
            while ((ch = System.in.read()) != -1 && ch != 10) {
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

