/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.process.exec.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.honton.chas.process.exec.maven.plugin.AbstractProcessMojo;
import org.honton.chas.process.exec.maven.plugin.CrossMojoState;
import org.honton.chas.process.exec.maven.plugin.ExecProcess;
import org.honton.chas.process.exec.maven.plugin.ProcessHealthCondition;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class ProcessStartMojo
extends AbstractProcessMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)("Skipping " + this.name));
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            for (String string : this.arguments) {
                this.getLog().debug((CharSequence)("arg: " + string));
            }
            if (this.environment != null) {
                for (Map.Entry entry : this.environment.entrySet()) {
                    this.getLog().debug((CharSequence)("env: " + (String)entry.getKey() + "=" + (String)entry.getValue()));
                }
            }
        }
        try {
            this.startProcess();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (this.waitForInterrupt) {
            this.sleepUntilInterrupted();
        }
    }

    private void startProcess() throws IOException {
        ExecProcess exec = new ExecProcess(this.name, this.getLog());
        if (null != this.processLogFile) {
            File plf = new File(this.processLogFile);
            ProcessStartMojo.ensureDirectory(plf.getParentFile());
            exec.setProcessLogFile(plf);
        }
        this.getLog().info((CharSequence)("Starting process: " + exec.getName()));
        exec.execute(this.processWorkingDirectory(), this.environment, this.arguments);
        CrossMojoState.get(this.getPluginContext()).add(exec);
        new ProcessHealthCondition(this.getLog(), this.healthCheckUrl, this.waitAfterLaunch, this.healthCheckValidateSsl).waitSecondsUntilHealthy();
        this.getLog().info((CharSequence)("Started process: " + exec.getName()));
    }

    private File processWorkingDirectory() throws IOException {
        String buildDir = this.project.getBuild().getDirectory();
        if (this.workingDir == null) {
            return ProcessStartMojo.ensureDirectory(new File(buildDir));
        }
        File pwd = new File(this.workingDir);
        if (!pwd.isAbsolute()) {
            pwd = new File(buildDir, this.workingDir);
        }
        return ProcessStartMojo.ensureDirectory(pwd);
    }
}

