/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.process.exec.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Stack;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.honton.chas.process.exec.maven.plugin.CrossMojoState;
import org.honton.chas.process.exec.maven.plugin.ExecProcess;
import org.honton.chas.process.exec.maven.plugin.HealthCheckUrl;

public abstract class AbstractProcessMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter(property="exec.arguments")
    protected String[] arguments;
    @Parameter(property="exec.environment")
    protected Map<String, String> environment;
    @Parameter(property="exec.workingDir")
    protected String workingDir;
    @Parameter(property="exec.name")
    protected String name;
    @Parameter(defaultValue="${exec.healthCheckUrl}")
    protected HealthCheckUrl healthCheckUrl;
    @Parameter(property="exec.healthCheckValidateSsl", defaultValue="true")
    protected boolean healthCheckValidateSsl;
    @Parameter(property="exec.waitAfterLaunch", required=false, defaultValue="30")
    protected int waitAfterLaunch;
    @Parameter(defaultValue="false", property="exec.waitForInterrupt")
    protected boolean waitForInterrupt;
    @Parameter(required=false, property="exec.processLogFile")
    protected String processLogFile;
    @Parameter(defaultValue="false", property="exec.skip")
    protected boolean skip;

    public void setHealthCheckUrl(String url) throws MalformedURLException {
        this.healthCheckUrl = new HealthCheckUrl();
        this.healthCheckUrl.setUrl(new URL(url));
    }

    protected static File ensureDirectory(File dir) {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new RuntimeException("couldn't create directories: " + dir);
        }
        return dir;
    }

    protected void sleepUntilInterrupted() throws IOException {
        int ch;
        this.getLog().info((CharSequence)"Hit ENTER on the console to continue the build.");
        while ((ch = System.in.read()) != -1 && ch != 10) {
        }
    }

    public AbstractProcessMojo() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Stack<ExecProcess> processesStack = CrossMojoState.getProcesses(AbstractProcessMojo.this.getPluginContext());
                if (!processesStack.empty()) {
                    AbstractProcessMojo.this.internalStopProcesses();
                }
            }
        });
    }

    protected void internalStopProcesses() {
        this.getLog().info((CharSequence)"Stopping all processes ...");
        Stack<ExecProcess> processesStack = CrossMojoState.getProcesses(this.getPluginContext());
        while (!processesStack.isEmpty()) {
            ExecProcess execProcess = processesStack.pop();
            if (execProcess == null) continue;
            this.getLog().info((CharSequence)("Stopping process: " + execProcess.getName()));
            execProcess.destroy();
            execProcess.waitFor();
            this.getLog().info((CharSequence)("Stopped process: " + execProcess.getName()));
        }
    }
}

