/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.process.exec.maven.plugin;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.honton.chas.process.exec.maven.plugin.MavenLogOutputStream;
import org.honton.chas.process.exec.maven.plugin.StdoutRedirector;

public class ExecProcess {
    private Process process = null;
    private final List<StdoutRedirector> redirectors = Lists.newArrayList();
    private File processLogFile = null;
    private final String name;

    public ExecProcess(String name) {
        this.name = name;
    }

    public void setProcessLogFile(File emoLogFile) {
        this.processLogFile = emoLogFile;
    }

    public String getName() {
        return this.name;
    }

    public void execute(File workingDirectory, Log log, Map<String, String> environment, String ... args) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        log.info((CharSequence)("Using working directory for this process: " + workingDirectory));
        pb.directory(workingDirectory);
        if (environment != null) {
            pb.environment().putAll(environment);
        }
        pb.command(args);
        try {
            this.process = pb.start();
            this.pumpOutputToLog(this.process, log);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void pumpOutputToLog(Process process, Log mavenLog) {
        if (this.processLogFile == null) {
            this.redirectors.add(new StdoutRedirector(new InputStreamReader(process.getInputStream()), (OutputStream)((Object)new MavenLogOutputStream(mavenLog, 1))));
            this.redirectors.add(new StdoutRedirector(new InputStreamReader(process.getErrorStream()), (OutputStream)((Object)new MavenLogOutputStream(mavenLog, 0))));
        } else {
            if (!this.processLogFile.getParentFile().isDirectory() && !this.processLogFile.getParentFile().mkdir()) {
                throw new IllegalStateException("Could not find or create directory containing " + this.processLogFile.getPath());
            }
            FileOutputStream out = ExecProcess.openFileOutputStream(this.processLogFile);
            this.redirectors.add(new StdoutRedirector(new InputStreamReader(process.getInputStream()), out));
            this.redirectors.add(new StdoutRedirector(new InputStreamReader(process.getErrorStream()), out));
        }
        for (StdoutRedirector redirector : this.redirectors) {
            redirector.start();
        }
    }

    private static FileOutputStream openFileOutputStream(File file) {
        FileOutputStream out;
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("couldn't create or open file '" + file + "'", e);
        }
        return out;
    }

    public void destroy() {
        for (StdoutRedirector redirector : this.redirectors) {
            redirector.stopIt();
        }
        this.process.destroy();
    }

    public void waitFor() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

