/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.process.exec.maven.plugin;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.honton.chas.process.exec.maven.plugin.AbstractProcessMojo;
import org.honton.chas.process.exec.maven.plugin.CrossMojoState;
import org.honton.chas.process.exec.maven.plugin.ExecProcess;
import org.honton.chas.process.exec.maven.plugin.ProcessHealthCondition;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class ProcessStartMojo
extends AbstractProcessMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)("Skipping " + this.name + " due to configuration skip=true"));
            return;
        }
        for (String arg : this.arguments) {
            this.getLog().info((CharSequence)("arg: " + arg));
        }
        if (this.environment != null) {
            for (Map.Entry entry : this.environment.entrySet()) {
                this.getLog().info((CharSequence)("env: " + (String)entry.getKey() + "=" + (String)entry.getValue()));
            }
        }
        this.getLog().info((CharSequence)("Full command line: " + Joiner.on((String)" ").useForNull("[null argument omitted]").join((Object[])this.arguments)));
        try {
            this.startProcess();
            if (this.waitForInterrupt) {
                this.sleepUntilInterrupted();
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    private void startProcess() {
        ExecProcess exec = new ExecProcess(this.name);
        if (null != this.processLogFile) {
            exec.setProcessLogFile(new File(this.processLogFile));
        }
        this.getLog().info((CharSequence)("Starting process: " + exec.getName()));
        Iterable nonNullArgumentList = Iterables.filter(Arrays.asList(this.arguments), (Predicate)Predicates.notNull());
        String[] nonNullArguments = (String[])Iterables.toArray((Iterable)nonNullArgumentList, String.class);
        exec.execute(this.processWorkingDirectory(), this.getLog(), this.environment, nonNullArguments);
        CrossMojoState.addProcess(exec, this.getPluginContext());
        new ProcessHealthCondition(this.getLog(), this.healthCheckUrl, this.waitAfterLaunch, this.healthCheckValidateSsl).waitSecondsUntilHealthy();
        this.getLog().info((CharSequence)("Started process: " + exec.getName()));
    }

    private File processWorkingDirectory() {
        if (this.workingDir == null) {
            return ProcessStartMojo.ensureDirectory(new File(this.project.getBuild().getDirectory()));
        }
        File potentialWorkingDir = new File(this.workingDir);
        if (potentialWorkingDir.isAbsolute() && potentialWorkingDir.exists() && potentialWorkingDir.isDirectory()) {
            return potentialWorkingDir;
        }
        return ProcessStartMojo.ensureDirectory(new File(this.project.getBuild().getDirectory(), this.workingDir));
    }
}

