/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.properties;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="write", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class WriteProperties
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Parameter(property="properties.filename", required=true)
    String filename;
    @Parameter(property="properties.defaults")
    String defaults;
    @Parameter
    Properties properties;
    @Parameter(property="properties.comment")
    String comment;
    @Parameter(property="properties.skip")
    boolean skip;
    @Parameter(property="mojoExecution", readonly=true)
    MojoExecution execution;
    private Path buildDirectory;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        this.buildDirectory = Path.of(this.project.getBuild().getDirectory(), new String[0]);
        Path location = this.buildDirectory.resolve(this.filename);
        this.createParentDirectory(location);
        this.writeProperties(location, this.getMerged());
    }

    private void createParentDirectory(Path location) throws MojoExecutionException {
        Path parent = location.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            try {
                this.getLog().debug((CharSequence)("Creating " + parent));
                Files.createDirectory(parent, new FileAttribute[0]);
                this.getLog().debug((CharSequence)("Created " + parent));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create " + parent, (Exception)e);
            }
        }
    }

    private Properties getMerged() throws MojoExecutionException {
        if (this.defaults != null) {
            Path location = this.buildDirectory.resolve(this.defaults);
            if (Files.exists(location, new LinkOption[0])) {
                Properties merged = this.readProperties(location);
                merged.putAll((Map<?, ?>)this.properties);
                return merged;
            }
            this.getLog().warn((CharSequence)("Inherited properties " + location + " does not exist"));
        }
        return this.properties;
    }

    private void writeProperties(Path location, Properties properties) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Saving " + location));
        try (BufferedWriter bw = Files.newBufferedWriter(location, new OpenOption[0]);){
            properties.store(bw, this.getComment());
            this.getLog().debug((CharSequence)("Saved " + location));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write " + location, (Exception)e);
        }
    }

    private Properties readProperties(Path location) throws MojoExecutionException {
        Properties properties = new Properties();
        this.getLog().debug((CharSequence)("Reading " + location));
        try (BufferedReader br = Files.newBufferedReader(location);){
            properties.load(br);
            this.getLog().debug((CharSequence)("Read " + location));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read " + location, (Exception)e);
        }
        return properties;
    }

    private String getComment() {
        String work = this.comment;
        work = work == null ? "" : work.trim();
        if (!work.isEmpty()) {
            return work;
        }
        return this.execution.getExecutionId();
    }
}

