/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.maven.readfiles;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.maven.readfiles.ChainedTransformation;
import org.honton.chas.maven.readfiles.NoopTransformation;
import org.honton.chas.maven.readfiles.RegexReplacementRule;
import org.honton.chas.maven.readfiles.Transformation;

@Mojo(name="readfiles", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class ReadFilesMojo
extends AbstractMojo {
    @Parameter(defaultValue="", property="readfiles.prefix")
    private String prefix;
    @Parameter(defaultValue="false", property="readfiles.trim")
    private boolean trim;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="false", property="readfiles.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.properties}", readonly=true, required=true)
    private Properties projectProperties;
    @Parameter
    private RegexReplacementRule[] regexReplacements;
    @Parameter
    private File[] files;

    private Transformation compileTransformations() throws MojoExecutionException {
        Transformation result = new NoopTransformation();
        if (null != this.regexReplacements) {
            for (int i = 0; i < this.regexReplacements.length; ++i) {
                try {
                    result = new ChainedTransformation(result, this.regexReplacements[i].compile());
                    continue;
                }
                catch (IllegalStateException e) {
                    throw new MojoExecutionException("Failed compiling regular expression at index " + i + ": " + e, (Exception)e);
                }
            }
        }
        return result;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping");
            return;
        }
        Charset charset = this.createCharset();
        Transformation transformation = this.compileTransformations();
        try {
            for (File file : this.files) {
                String propertyName = this.createPropertyName(file);
                String propertyValue = transformation.transform(this.readFileFully(file, charset));
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(propertyName + " = " + propertyValue));
                } else {
                    this.getLog().info((CharSequence)("setting " + propertyName));
                }
                this.projectProperties.setProperty(propertyName, propertyValue);
            }
        }
        catch (IOException io) {
            throw new MojoExecutionException(io.getMessage(), (Exception)io);
        }
    }

    private String createPropertyName(File file) {
        return this.prefix != null ? this.prefix + file.getName() : file.getName();
    }

    private Charset createCharset() {
        return this.encoding != null ? Charset.forName(this.encoding) : StandardCharsets.UTF_8;
    }

    private String readFileFully(File file, Charset charset) throws IOException {
        byte[] encoded = Files.readAllBytes(file.toPath());
        String result = new String(encoded, charset);
        if (this.trim) {
            return result.trim();
        }
        return result;
    }
}

