/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.AbstractScanner;

public class PojoScanner
extends AbstractScanner {
    private final Log log;
    private final Collection<String> collector;
    private static final List<String> NO_ARGS = Collections.emptyList();
    private static final List<String> SINGLE_OBJECT_ARG = Arrays.asList("java.lang.Object");

    public void scan(Object cls) {
        MetadataAdapter meta = this.getConfiguration().getMetadataAdapter();
        String className = meta.getClassName(cls);
        if (PojoScanner.hasEqualsAndHashCode(meta, cls)) {
            this.collector.add(className);
        }
    }

    private static <C, F, M> boolean hasEqualsAndHashCode(MetadataAdapter<C, F, M> meta, C cls) {
        boolean equals = false;
        boolean hashCode = false;
        for (Object method : meta.getMethods(cls)) {
            if (!(equals |= PojoScanner.isMethod(meta, method, "boolean", "equals", SINGLE_OBJECT_ARG)) || !(hashCode |= PojoScanner.isMethod(meta, method, "int", "hashCode", NO_ARGS))) continue;
            return true;
        }
        return false;
    }

    private static <C, F, M> boolean isMethod(MetadataAdapter<C, F, M> meta, M method, String returnType, String methodName, List<String> parameterNames) {
        return meta.getReturnTypeName(method).equals(returnType) && meta.getMethodName(method).equals(methodName) && meta.getParameterNames(method).equals(parameterNames);
    }

    @ConstructorProperties(value={"log", "collector"})
    public PojoScanner(Log log, Collection<String> collector) {
        this.log = log;
        this.collector = collector;
    }
}

