/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.benas.randombeans.EnhancedRandomBuilder;
import io.github.benas.randombeans.api.EnhancedRandom;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.honton.chas.testpojo.Builder;
import org.honton.chas.testpojo.PojoScanner;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class TestPojoMojo
extends AbstractMojo {
    @Parameter(property="project.runtimeClasspathElements", readonly=true)
    private List<String> runtimeScope;
    @Parameter(property="project.compileClasspathElements", readonly=true)
    private List<String> compileScope;
    @Parameter(property="project.build.outputDirectory", readonly=true)
    private String outputDirectory;
    private static final TypeReference<Map<String, Object>> MAP_STRING_TO_OBJECT_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public void execute() throws MojoExecutionException {
        int errors = this.testPojos();
        if (errors > 0) {
            throw new MojoExecutionException(errors + " pojos had errors");
        }
    }

    @SafeVarargs
    private final URL[] getUrls(String classes, List<String> ... scopes) {
        HashSet<URL> urls = new HashSet<URL>();
        this.addUrl(urls, classes);
        for (List<String> elements : scopes) {
            this.addScope(urls, elements);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private void addScope(Set<URL> urls, List<String> elements) {
        for (String element : elements) {
            this.addUrl(urls, element);
        }
    }

    private void addUrl(Set<URL> urls, String element) {
        try {
            urls.add(new File(element).toURI().toURL());
        }
        catch (MalformedURLException e) {
            this.getLog().info((CharSequence)(element + " not a valid location"));
        }
    }

    private List<String> getPojoNames() {
        ArrayList<String> collector = new ArrayList<String>();
        new Reflections((Configuration)new ConfigurationBuilder().setUrls(this.getUrls(this.outputDirectory, new List[0])).setScanners(new Scanner[]{new PojoScanner(this.getLog(), collector)}));
        return collector;
    }

    private ClassLoader createClassLoader() {
        return new URLClassLoader(this.getUrls(this.outputDirectory, this.compileScope, this.runtimeScope), Thread.currentThread().getContextClassLoader());
    }

    private List<Class<?>> getPojoClasses() {
        return ReflectionUtils.forNames(this.getPojoNames(), (ClassLoader[])new ClassLoader[]{this.createClassLoader()});
    }

    public int testPojos() {
        EnhancedRandom randomBuilder = EnhancedRandomBuilder.aNewEnhancedRandomBuilder().build();
        int errors = 0;
        for (Class<?> dtoClass : this.getPojoClasses()) {
            this.getLog().info((CharSequence)("testing " + dtoClass.getCanonicalName()));
            try {
                this.testPojoInstance(dtoClass, dtoClass.newInstance());
                this.testPojoInstance(dtoClass, randomBuilder.nextObject(dtoClass, new String[0]));
            }
            catch (Exception ex) {
                ++errors;
                this.getLog().error((CharSequence)dtoClass.getCanonicalName(), (Throwable)ex);
            }
        }
        return errors;
    }

    private boolean testPojoInstance(Class<?> dtoClass, Object dto) {
        dto.toString();
        return this.testPojoToMapToPojo(dtoClass, dto) && this.testPojoToBuilderToPojo(dtoClass, dto);
    }

    private boolean testPojoToBuilderToPojo(Class<?> dtoClass, Object dto) {
        Builder helper = new Builder(this.getLog(), dtoClass);
        if (!helper.createBuilder(dto)) {
            return true;
        }
        if (!helper.isInstanceBuilder()) {
            Map map = (Map)OBJECT_MAPPER.convertValue(dto, MAP_STRING_TO_OBJECT_TYPE);
            helper.setBuilderValues(map);
        }
        return this.comparePojos(dto, helper.build());
    }

    private boolean testPojoToMapToPojo(Class<?> dtoClass, Object dto) {
        Map map = (Map)OBJECT_MAPPER.convertValue(dto, MAP_STRING_TO_OBJECT_TYPE);
        Object copy = OBJECT_MAPPER.convertValue((Object)map, dtoClass);
        return this.comparePojos(dto, copy);
    }

    private boolean comparePojos(Object dto, Object copy) {
        if (!dto.equals(copy)) {
            this.getLog().error((CharSequence)(dto + " != " + copy));
            return false;
        }
        if (dto.hashCode() != copy.hashCode()) {
            this.getLog().error((CharSequence)(dto.hashCode() + " != " + copy.hashCode()));
            return false;
        }
        return true;
    }
}

