/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class BuildExecJar {
    private final String argLine;
    private final File jarLocation;
    private final String mainClass;

    public final void buildJar(Set<String> dependencies) throws IOException {
        StringBuilder cp = new StringBuilder();
        for (String dependency : dependencies) {
            cp.append(dependency);
            if (!dependency.endsWith(".jar")) {
                cp.append('/');
            }
            cp.append(' ');
        }
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        mainAttributes.put(Attributes.Name.CLASS_PATH, cp.toString());
        mainAttributes.put(Attributes.Name.IMPLEMENTATION_TITLE, this.argLine);
        new JarOutputStream((OutputStream)new FileOutputStream(this.jarLocation), manifest).close();
    }

    @ConstructorProperties(value={"argLine", "jarLocation", "mainClass"})
    public BuildExecJar(String argLine, File jarLocation, String mainClass) {
        this.argLine = argLine;
        this.jarLocation = jarLocation;
        this.mainClass = mainClass;
    }
}

