/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;

public class Builder {
    private Method publicStaticBuilderMethod;
    private Method publicBuildMethod;
    private Method publicToBuilderMethod;
    private Object builder;
    private static final Map<Class<?>, Class<?>> PRIMATIVE_TO_WRAPPER = ImmutableMap.builder().put(Byte.TYPE, Byte.class).put(Short.TYPE, Short.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Float.TYPE, Float.class).put(Double.TYPE, Double.class).put(Character.TYPE, Character.class).put(Boolean.TYPE, Boolean.class).build();

    public Builder(Class<?> dtoClass) {
        if (this.findBuilderMethod(dtoClass)) {
            this.findInstanceBuilder(dtoClass);
        }
    }

    public boolean createBuilder(Object dto) {
        if (this.publicStaticBuilderMethod == null) {
            return false;
        }
        this.builder = (this.publicToBuilderMethod != null ? this.publicToBuilderMethod : this.publicStaticBuilderMethod).invoke(dto, new Object[0]);
        this.builder.toString();
        return true;
    }

    public boolean isInstanceBuilder() {
        return this.publicToBuilderMethod != null;
    }

    public Object build() {
        return this.publicBuildMethod.invoke(this.builder, new Object[0]);
    }

    public void setBuilderValues(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.invokeSetter(entry.getKey(), entry.getValue());
        }
    }

    private void invokeSetter(String name, Object value) {
        for (Method mth : this.builder.getClass().getDeclaredMethods()) {
            if (Modifier.isStatic(mth.getModifiers()) || !mth.getName().equals(name) || mth.getParameterTypes().length != 1) continue;
            Class<?> parameterClass = mth.getParameterTypes()[0];
            if (parameterClass.isPrimitive()) {
                if (value == null) continue;
                parameterClass = PRIMATIVE_TO_WRAPPER.get(parameterClass);
            }
            if (!parameterClass.isAssignableFrom(value.getClass())) continue;
            try {
                mth.invoke(this.builder, value);
                return;
            }
            catch (Exception e) {
                System.err.println("builder method " + name + ": " + e.getMessage());
            }
        }
    }

    private boolean findBuilderMethod(Class<?> dtoClass) {
        for (Method method : dtoClass.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !this.findBuildMethod(dtoClass, method.getReturnType())) continue;
            this.publicStaticBuilderMethod = method;
            return true;
        }
        return false;
    }

    private boolean findBuildMethod(Class<?> dtoClass, Class<?> builderClass) {
        for (Method method : builderClass.getDeclaredMethods()) {
            if (!method.getReturnType().equals(dtoClass) || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
            this.publicBuildMethod = method;
            return true;
        }
        return false;
    }

    private void findInstanceBuilder(Class<?> dtoClass) {
        try {
            Method method = dtoClass.getDeclaredMethod("toBuilder", new Class[0]);
            if (Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
                this.publicToBuilderMethod = method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

