/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.benas.randombeans.EnhancedRandomBuilder;
import io.github.benas.randombeans.api.EnhancedRandom;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.honton.chas.testpojo.Builder;
import org.honton.chas.testpojo.PojoScanner;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;

public class Main {
    private final File classesDirectory;
    private static final TypeReference<Map<String, Object>> MAP_STRING_TO_OBJECT_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) {
        System.exit(new Main(new File(args[0])).testPojos());
    }

    public int testPojos() {
        EnhancedRandom randomBuilder = EnhancedRandomBuilder.aNewEnhancedRandomBuilder().build();
        int errors = 0;
        for (String pojoName : this.getPojoNames()) {
            try {
                Class<?> pojoClass = Class.forName(pojoName);
                this.testPojoInstance(pojoClass, pojoClass.newInstance());
                this.testPojoInstance(pojoClass, randomBuilder.nextObject(pojoClass, new String[0]));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                ++errors;
                System.err.println(pojoName + ": " + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        return errors;
    }

    private List<String> getPojoNames() {
        ArrayList<String> collector = new ArrayList<String>();
        new Reflections((Configuration)new ConfigurationBuilder().setUrls(Collections.singletonList(this.classesDirectory.toURI().toURL())).setScanners(new Scanner[]{new PojoScanner(collector)}));
        return collector;
    }

    private boolean testPojoInstance(Class<?> pojoClass, Object pojo) {
        pojo.toString();
        return this.testPojoToMapToPojo(pojoClass, pojo) && this.testPojoToBuilderToPojo(pojoClass, pojo);
    }

    private boolean testPojoToBuilderToPojo(Class<?> pojoClass, Object pojo) {
        Builder helper = new Builder(pojoClass);
        if (!helper.createBuilder(pojo)) {
            return true;
        }
        if (!helper.isInstanceBuilder()) {
            Map map = (Map)OBJECT_MAPPER.convertValue(pojo, MAP_STRING_TO_OBJECT_TYPE);
            helper.setBuilderValues(map);
        }
        return this.comparePojos(pojo, helper.build());
    }

    private boolean testPojoToMapToPojo(Class<?> pojoClass, Object pojo) {
        Map map = (Map)OBJECT_MAPPER.convertValue(pojo, MAP_STRING_TO_OBJECT_TYPE);
        Object copy = OBJECT_MAPPER.convertValue((Object)map, pojoClass);
        return this.comparePojos(pojo, copy);
    }

    private boolean comparePojos(Object pojo, Object copy) {
        if (!pojo.equals(copy)) {
            System.err.println(pojo + " != " + copy);
            return false;
        }
        if (pojo.hashCode() != copy.hashCode()) {
            System.err.println(pojo.hashCode() + " != " + copy.hashCode());
            return false;
        }
        return true;
    }

    @ConstructorProperties(value={"classesDirectory"})
    public Main(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }
}

