/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.honton.chas.testpojo.BuildExecJar;
import org.honton.chas.testpojo.JavaProcess;
import org.honton.chas.testpojo.Main;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class TestPojoMojo
extends AbstractMojo {
    @Parameter(property="project.runtimeClasspathElements", readonly=true)
    private List<String> runtimeScope;
    @Parameter(property="project.compileClasspathElements", readonly=true)
    private List<String> compileScope;
    @Parameter(property="project.build.outputDirectory", readonly=true)
    private String outputDirectory;
    @Parameter(property="project.build.directory", readonly=true)
    private String buildDirectory;
    @Parameter(property="project.model.properties", readonly=true)
    private Map<String, String> properties;
    private static final Pattern ARG_PATTERN = Pattern.compile("@\\{([^}]+)\\}");

    public void execute() throws MojoExecutionException {
        String argLine = this.properties.get("argLine");
        if (argLine == null) {
            this.getLog().warn((CharSequence)"No argLine specifying javaagent - not continuing");
            return;
        }
        argLine = this.replaceProperties(argLine);
        try {
            File jarFileLocation = new File(this.buildDirectory, "testPojo.jar");
            HashSet<String> dependencies = new HashSet<String>();
            dependencies.addAll(this.runtimeScope);
            dependencies.addAll(this.compileScope);
            this.addMyDependencies(dependencies);
            new BuildExecJar(argLine, jarFileLocation, Main.class.getCanonicalName()).buildJar(dependencies);
            JavaProcess proc = new JavaProcess(this.getLog());
            proc.setJavaArgs(Arrays.asList(argLine, "-jar", jarFileLocation.getAbsolutePath()));
            proc.setCmdArgs(Arrays.asList(this.outputDirectory));
            int errors = proc.execute();
            if (errors > 0) {
                throw new MojoExecutionException(errors + " pojos had errors");
            }
        }
        catch (IOException | URISyntaxException | ExecutionException | TimeoutException ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private void addMyDependencies(Set<String> dependencies) throws URISyntaxException {
        URLClassLoader ucl = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        for (URL url : ucl.getURLs()) {
            dependencies.add(url.toURI().getPath());
        }
    }

    private String replaceProperties(String argLine) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        Matcher m = ARG_PATTERN.matcher(argLine);
        while (m.find()) {
            String value = this.properties.get(m.group(1));
            if (value == null) continue;
            sb.append(argLine.substring(start, m.start()));
            sb.append(value);
            start = m.end();
        }
        if (start != 0) {
            return sb.append(argLine.substring(start)).toString();
        }
        return argLine;
    }
}

