/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.plugin.logging.Log;

public class JavaProcess {
    private final Log log;
    private List<String> javaArgs;
    private List<String> cmdArgs;
    private ExecutorService executor;

    public int execute() throws Exception {
        this.executor = Executors.newFixedThreadPool(2);
        try {
            int n = this.startAndWait();
            return n;
        }
        finally {
            this.executor.shutdown();
        }
    }

    private int startAndWait() throws ExecutionException, IOException, TimeoutException {
        Process process = this.startProcess();
        try {
            this.closeOutputStream(process.getOutputStream());
            Future<IOException> stderrFuture = this.startStreamPump(process.getErrorStream(), new Consumer<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(String line) {
                    Log log = JavaProcess.this.log;
                    synchronized (log) {
                        JavaProcess.this.log.error((CharSequence)line);
                    }
                }
            });
            Future<IOException> stdoutFuture = this.startStreamPump(process.getInputStream(), new Consumer<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void accept(String line) {
                    Log log = JavaProcess.this.log;
                    synchronized (log) {
                        JavaProcess.this.log.info((CharSequence)line);
                    }
                }
            });
            this.stopStreamPump(stderrFuture);
            this.stopStreamPump(stdoutFuture);
            return this.checkProcessExit(process);
        }
        catch (ExecutionException | TimeoutException e) {
            process.destroy();
            throw e;
        }
    }

    private int checkProcessExit(Process process) {
        try {
            return process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            process.destroy();
            return 0;
        }
    }

    private void closeOutputStream(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException e) {
            this.log.info((CharSequence)("failed to close output stream: " + e.getMessage()));
        }
    }

    private String getJava() {
        String javaHome = System.getProperty("java.home");
        return javaHome + File.separator + "bin" + File.separator + "java";
    }

    private Process startProcess() throws IOException {
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add(this.getJava());
        if (this.javaArgs != null) {
            allArgs.addAll(this.javaArgs);
        }
        if (this.cmdArgs != null) {
            allArgs.addAll(this.cmdArgs);
        }
        return Runtime.getRuntime().exec(allArgs.toArray(new String[allArgs.size()]));
    }

    private Future<IOException> startStreamPump(final InputStream errorStream, final Consumer<String> logLine) {
        return this.executor.submit(new Callable<IOException>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public IOException call() {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));){
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            IOException iOException = null;
                            return iOException;
                        }
                        logLine.accept(line);
                    }
                }
                catch (IOException e) {
                    return e;
                }
            }
        });
    }

    private void stopStreamPump(Future<IOException> future) throws ExecutionException, TimeoutException, IOException {
        try {
            IOException e = future.get(20L, TimeUnit.SECONDS);
            if (e != null) {
                throw e;
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    public Log getLog() {
        return this.log;
    }

    public List<String> getJavaArgs() {
        return this.javaArgs;
    }

    public List<String> getCmdArgs() {
        return this.cmdArgs;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setJavaArgs(List<String> javaArgs) {
        this.javaArgs = javaArgs;
    }

    public void setCmdArgs(List<String> cmdArgs) {
        this.cmdArgs = cmdArgs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaProcess)) {
            return false;
        }
        JavaProcess other = (JavaProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Log this$log = this.getLog();
        Log other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        List<String> this$javaArgs = this.getJavaArgs();
        List<String> other$javaArgs = other.getJavaArgs();
        if (this$javaArgs == null ? other$javaArgs != null : !((Object)this$javaArgs).equals(other$javaArgs)) {
            return false;
        }
        List<String> this$cmdArgs = this.getCmdArgs();
        List<String> other$cmdArgs = other.getCmdArgs();
        if (this$cmdArgs == null ? other$cmdArgs != null : !((Object)this$cmdArgs).equals(other$cmdArgs)) {
            return false;
        }
        ExecutorService this$executor = this.getExecutor();
        ExecutorService other$executor = other.getExecutor();
        return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavaProcess;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Log $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        List<String> $javaArgs = this.getJavaArgs();
        result = result * 59 + ($javaArgs == null ? 43 : ((Object)$javaArgs).hashCode());
        List<String> $cmdArgs = this.getCmdArgs();
        result = result * 59 + ($cmdArgs == null ? 43 : ((Object)$cmdArgs).hashCode());
        ExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        return result;
    }

    public String toString() {
        return "JavaProcess(log=" + this.getLog() + ", javaArgs=" + this.getJavaArgs() + ", cmdArgs=" + this.getCmdArgs() + ", executor=" + this.getExecutor() + ")";
    }

    @ConstructorProperties(value={"log"})
    public JavaProcess(Log log) {
        this.log = log;
    }

    private static interface Consumer<T> {
        public void accept(T var1);
    }
}

