/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.honton.chas.testpojo.PojoClassTester;
import org.honton.chas.testpojo.PojoScanner;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;

public class Main {
    private final File classesDirectory;
    private final File dependencies;

    public static void main(String[] args) throws IOException {
        System.exit(new Main(new File(args[0]), new File(args[1])).testPojos());
    }

    public int testPojos() throws IOException {
        ClassLoader pojoClassLoader = this.getDependencies();
        int errors = 0;
        for (String pojoName : this.getPojoNames()) {
            try {
                new PojoClassTester(pojoClassLoader, pojoName).test();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                ++errors;
                System.err.println(pojoName + ": " + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        return errors;
    }

    private ClassLoader getDependencies() throws IOException {
        ArrayList<URL> jars = new ArrayList<URL>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dependencies), StandardCharsets.UTF_8));){
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    URLClassLoader uRLClassLoader = new URLClassLoader(jars.toArray(new URL[jars.size()]), this.getClass().getClassLoader());
                    return uRLClassLoader;
                }
                jars.add(new File(line).toURI().toURL());
            }
        }
    }

    private List<String> getPojoNames() throws MalformedURLException {
        ArrayList<String> collector = new ArrayList<String>();
        new Reflections((Configuration)new ConfigurationBuilder().setUrls(Collections.singletonList(this.classesDirectory.toURI().toURL())).setScanners(new Scanner[]{new PojoScanner(collector)}));
        return collector;
    }

    @ConstructorProperties(value={"classesDirectory", "dependencies"})
    public Main(File classesDirectory, File dependencies) {
        this.classesDirectory = classesDirectory;
        this.dependencies = dependencies;
    }
}

