/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.honton.chas.testpojo.PojoBuilder;

public class PojoClass {
    private static final TypeReference<Map<String, Object>> MAP_STRING_TO_OBJECT_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final ClassLoader classLoader;
    private final Class<?> pojoClass;
    private final Constructor<?> constructor;
    private final List<Method> setters = new ArrayList<Method>();
    private static final Map<Class<?>, Object> DEFAULT_VALUES = new HashMap<Class<?>, Object>(){
        {
            this.put(Boolean.TYPE, false);
            this.put(Byte.TYPE, (byte)0);
            this.put(Character.TYPE, Character.valueOf('\u0000'));
            this.put(Short.TYPE, (short)0);
            this.put(Integer.TYPE, 0);
            this.put(Long.TYPE, 0L);
            this.put(Float.TYPE, Float.valueOf(0.0f));
            this.put(Double.TYPE, 0.0);
        }
    };
    private static final Map<Class<?>, Object> VARIENT_VALUES = new HashMap<Class<?>, Object>(){
        {
            this.put(Boolean.TYPE, true);
            this.put(Byte.TYPE, (byte)1);
            this.put(Character.TYPE, Character.valueOf('\u0001'));
            this.put(Short.TYPE, (short)1);
            this.put(Integer.TYPE, 1);
            this.put(Long.TYPE, 1L);
            this.put(Float.TYPE, Float.valueOf(1.0f));
            this.put(Double.TYPE, 1.0);
        }
    };

    PojoClass(ClassLoader classLoader, String pojoClassName) throws ClassNotFoundException {
        this(classLoader, classLoader.loadClass(pojoClassName));
    }

    PojoClass(ClassLoader classLoader, Class<?> pojoClass) throws ClassNotFoundException {
        this.classLoader = classLoader;
        this.pojoClass = pojoClass;
        this.constructor = this.findConstructor();
        this.findSetters();
    }

    public boolean isTestable() {
        return this.constructor != null;
    }

    public Object createCopyThroughMap(Object pojo) {
        Map map = (Map)OBJECT_MAPPER.convertValue(pojo, MAP_STRING_TO_OBJECT_TYPE);
        return OBJECT_MAPPER.convertValue((Object)map, this.pojoClass);
    }

    public int getVariationCount() {
        return Math.max(this.constructor.getParameterTypes().length, this.setters.size());
    }

    public Object createVariant(int varientIdx) throws Exception {
        Object o = this.constructor.newInstance(this.createArgs(varientIdx));
        if (varientIdx >= this.constructor.getParameterTypes().length) {
            Method setter = this.setters.get(varientIdx);
            setter.invoke(o, this.createVariant(setter.getParameterTypes()[0], true));
        }
        return o;
    }

    private Object[] createArgs(int variantIdx) throws Exception {
        Class<?>[] argTypes = this.constructor.getParameterTypes();
        Object[] args = new Object[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            args[i] = this.createVariant(argTypes[i], i == variantIdx);
        }
        return args;
    }

    private Object createVariant(Class<?> argType, boolean isVarient) throws Exception {
        if (isVarient) {
            Object rc = VARIENT_VALUES.get(argType);
            if (rc != null) {
                return rc;
            }
            if (argType.isAssignableFrom(Collection.class) || argType.isAssignableFrom(List.class)) {
                return new ArrayList();
            }
            if (argType.isAssignableFrom(Map.class)) {
                return new HashMap();
            }
            PojoClass pc = new PojoClass(this.classLoader, argType);
            if (pc.isTestable()) {
                return pc.createVariant(-1);
            }
        }
        return DEFAULT_VALUES.get(argType);
    }

    private Constructor<?> findConstructor() {
        int leastNArgs = Integer.MAX_VALUE;
        Constructor<?> leastArgs = null;
        for (Constructor<?> constructor : this.pojoClass.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            int nArgs = constructor.getParameterTypes().length;
            if (nArgs == 0) {
                return constructor;
            }
            if (nArgs >= leastNArgs) continue;
            nArgs = leastNArgs;
            leastArgs = constructor;
        }
        return leastArgs;
    }

    private void findSetters() {
        for (Method method : this.pojoClass.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !Void.TYPE.equals(method.getReturnType()) || 1 != method.getParameterTypes().length || !method.getName().startsWith("set")) continue;
            this.setters.add(method);
        }
    }

    public Object createCopyThroughBuilder(Object pojo) {
        PojoBuilder builder = new PojoBuilder(this.pojoClass);
        if (!builder.createBuilder(pojo)) {
            return null;
        }
        if (!builder.isInstanceBuilder()) {
            Map map = (Map)OBJECT_MAPPER.convertValue(pojo, MAP_STRING_TO_OBJECT_TYPE);
            builder.setBuilderValues(map);
        }
        return builder.build();
    }
}

