/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import org.honton.chas.testpojo.PojoClass;

public class PojoClassTester {
    private final PojoClass pojoClass;

    PojoClassTester(ClassLoader pojoClassLoader, String pojoClassName) throws ClassNotFoundException {
        this.pojoClass = new PojoClass(pojoClassLoader, pojoClassName);
    }

    public boolean test() throws Exception {
        if (!this.pojoClass.isTestable()) {
            return true;
        }
        Object standard = this.createVariant(-1);
        if (standard == null) {
            return false;
        }
        int variantCount = this.pojoClass.getVariationCount();
        if (variantCount > 0 && !this.testVariationInEquality(standard, variantCount)) {
            return false;
        }
        if (!standard.equals(standard)) {
            System.err.println("this !== this");
            return false;
        }
        if (standard.equals(null)) {
            System.err.println("this == null");
            return false;
        }
        if (standard.equals(new Object())) {
            System.err.println("this == new Object()");
            return false;
        }
        return true;
    }

    private boolean testVariationInEquality(Object standard, int variantCount) throws Exception {
        Object prior = standard;
        for (int i = 0; i < variantCount; ++i) {
            Object variant = this.createVariant(i);
            if (variant == null || PojoClassTester.equal(prior, variant)) {
                return false;
            }
            prior = variant;
        }
        return !PojoClassTester.equal(prior, standard);
    }

    private static boolean equal(Object prior, Object variant) {
        boolean equal = variant.equals(prior);
        if (equal) {
            System.err.println(variant + " == " + prior);
        }
        return equal;
    }

    private Object createVariant(int variantIdx) throws Exception {
        Object variant = this.pojoClass.createVariant(variantIdx);
        variant.toString();
        return this.testPojoToMapToPojo(variant) && this.testPojoToBuilderToPojo(variant) ? variant : null;
    }

    private boolean testPojoToBuilderToPojo(Object pojo) {
        Object copy = this.pojoClass.createCopyThroughBuilder(pojo);
        return copy == null || this.comparePojos(pojo, copy);
    }

    private boolean testPojoToMapToPojo(Object pojo) {
        return this.comparePojos(pojo, this.pojoClass.createCopyThroughMap(pojo));
    }

    private boolean comparePojos(Object pojo, Object copy) {
        if (pojo == copy) {
            System.err.println("pojo === copy");
            return false;
        }
        if (!pojo.equals(copy)) {
            System.err.println(pojo + " != " + copy);
            return false;
        }
        if (pojo.hashCode() != copy.hashCode()) {
            System.err.println(pojo.hashCode() + " != " + copy.hashCode());
            return false;
        }
        return true;
    }
}

