/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.AbstractScanner;

public class PojoScanner
extends AbstractScanner {
    private final Collection<String> collector;
    private static final List<String> NO_ARGS = Collections.emptyList();
    private static final List<String> SINGLE_OBJECT_ARG = Arrays.asList("java.lang.Object");

    public void scan(Object cls) {
        MetadataAdapter meta = this.getConfiguration().getMetadataAdapter();
        if (PojoScanner.hasEqualsAndHashCode(meta, cls)) {
            this.collector.add(meta.getClassName(cls));
        }
    }

    private static <C, F, M> boolean hasEqualsAndHashCode(MetadataAdapter<C, F, M> meta, C cls) {
        boolean equals = false;
        boolean hashCode = false;
        boolean publicConstructor = false;
        for (Object method : meta.getMethods(cls)) {
            if (!(equals |= PojoScanner.isMethod(meta, method, "boolean", "equals", SINGLE_OBJECT_ARG)) || !(hashCode |= PojoScanner.isMethod(meta, method, "int", "hashCode", NO_ARGS)) || !(publicConstructor |= PojoScanner.isConstructor(meta, method, "int", "<init>", NO_ARGS))) continue;
            return true;
        }
        return false;
    }

    private static <C, F, M> boolean isMethod(MetadataAdapter<C, F, M> meta, M method, String returnType, String methodName, List<String> parameterNames) {
        return returnType.equals(meta.getReturnTypeName(method)) && methodName.equals(meta.getMethodName(method)) && parameterNames.equals(meta.getParameterNames(method));
    }

    private static <C, F, M> boolean isConstructor(MetadataAdapter<C, F, M> meta, M method, String returnType, String methodName, List<String> parameterNames) {
        return "<init>".equals(meta.getMethodName(method)) && meta.isPublic(method);
    }

    @ConstructorProperties(value={"collector"})
    public PojoScanner(Collection<String> collector) {
        this.collector = collector;
    }
}

