/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.honton.chas.testpojo.PojoBuilder;

public class PojoClass {
    private static final TypeReference<Map<String, Object>> MAP_STRING_TO_OBJECT_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new GuavaModule()).registerModule((Module)new JodaModule());
    private static final Map<Class<?>, Object> STANDARD_VALUES = new HashMap<Class<?>, Object>(){
        {
            this.put(Boolean.TYPE, false);
            this.put(Byte.TYPE, (byte)0);
            this.put(Character.TYPE, Character.valueOf('\u0000'));
            this.put(Short.TYPE, (short)0);
            this.put(Integer.TYPE, 0);
            this.put(Long.TYPE, 0L);
            this.put(Float.TYPE, Float.valueOf(0.0f));
            this.put(Double.TYPE, 0.0);
        }
    };
    private static final Map<Class<?>, Object> VARIANT_VALUES = new HashMap<Class<?>, Object>(){
        {
            this.put(Boolean.TYPE, true);
            this.put(Byte.TYPE, (byte)1);
            this.put(Character.TYPE, Character.valueOf('\u0001'));
            this.put(Short.TYPE, (short)1);
            this.put(Integer.TYPE, 1);
            this.put(Long.TYPE, 1L);
            this.put(Float.TYPE, Float.valueOf(1.0f));
            this.put(Double.TYPE, 1.0);
            this.put(Boolean.class, Boolean.TRUE);
            this.put(Byte.class, new Byte(1));
            this.put(Character.class, new Character('\u0001'));
            this.put(Short.class, new Short(1));
            this.put(Integer.class, new Integer(1));
            this.put(Long.class, new Long(1L));
            this.put(Float.class, new Float(1.0f));
            this.put(Double.class, new Double(1.0));
        }
    };
    private static Map<Class<?>, PojoClass> cache = new HashMap();
    private final Class<?> pojoClass;
    private final Constructor<?> constructor;
    private final List<Method> setters = new ArrayList<Method>();
    private Argument[] arguments;

    private PojoClass(Class<?> pojoClass) {
        this.pojoClass = pojoClass;
        this.constructor = this.findConstructor();
        cache.put(pojoClass, this);
        if (this.constructor == null) {
            System.out.println("No public constructor for " + pojoClass.getCanonicalName());
        } else {
            this.findSetters();
        }
    }

    static PojoClass from(Class<?> pojoClass) {
        PojoClass pc = cache.get(pojoClass);
        return pc == null ? new PojoClass(pojoClass) : pc;
    }

    private Argument[] getArguments() {
        block4: {
            if (this.arguments != null) break block4;
            Class<?>[] argTypes = this.constructor.getParameterTypes();
            if (argTypes.length > 0) {
                this.arguments = new Argument[argTypes.length];
                int i = 0;
                for (Class<?> argType : argTypes) {
                    this.arguments[i++] = new Argument(argType);
                }
            } else {
                this.arguments = new Argument[this.setters.size()];
                int i = 0;
                for (Method setter : this.setters) {
                    Class<?> argType = setter.getParameterTypes()[0];
                    this.arguments[i++] = new Argument(argType);
                }
            }
        }
        return this.arguments;
    }

    public boolean isConstructable() {
        return this.constructor != null;
    }

    public boolean isJacksonSerializable() {
        return this.pojoClass.getAnnotation(JsonIgnoreType.class) == null;
    }

    public Object createCopyThroughMap(Object pojo) {
        Map map = (Map)OBJECT_MAPPER.convertValue(pojo, MAP_STRING_TO_OBJECT_TYPE);
        return OBJECT_MAPPER.convertValue((Object)map, this.pojoClass);
    }

    public Object createCopyThroughString(Object pojo) throws IOException {
        String json = OBJECT_MAPPER.writeValueAsString(pojo);
        return OBJECT_MAPPER.readValue(json, this.pojoClass);
    }

    public int getVariationCount() {
        return Math.max(this.constructor.getParameterTypes().length, this.setters.size());
    }

    public Object createVariant(int variantIdx) {
        try {
            Object[] args = this.createInstantiationArgs(variantIdx);
            Object o = this.constructor.newInstance(args);
            if (variantIdx >= this.constructor.getParameterTypes().length) {
                Method setter = this.setters.get(variantIdx);
                Object variant = PojoClass.createInstance(setter.getParameterTypes()[0]);
                setter.invoke(o, variant);
            }
            return o;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    private Object[] createInstantiationArgs(int variantIdx) {
        Argument[] arguments = this.getArguments();
        Object[] args = new Object[this.constructor.getParameterCount()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = arguments[i].getArgument(i == variantIdx);
        }
        return args;
    }

    private static Object createInstance(Class<?> argType) {
        Object rc = VARIANT_VALUES.get(argType);
        if (rc != null) {
            return rc;
        }
        if (argType.isAssignableFrom(Collection.class) || argType.isAssignableFrom(List.class)) {
            return new ArrayList();
        }
        if (argType.isAssignableFrom(Map.class)) {
            return new HashMap();
        }
        if (argType.isAssignableFrom(ImmutableList.class)) {
            return ImmutableList.of();
        }
        if (argType.isEnum()) {
            return PojoClass.getFirstEnumValue(argType);
        }
        PojoClass pc = PojoClass.from(argType);
        if (pc.isConstructable()) {
            return pc.createVariant(-1);
        }
        System.out.println("could not create instance of " + argType.getCanonicalName());
        return null;
    }

    private static Object getFirstEnumValue(Class<?> enumClass) {
        try {
            Object[] values = (Object[])enumClass.getDeclaredMethod("values", new Class[0]).invoke(null, new Object[0]);
            return values.length > 0 ? values[0] : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Constructor<?> findConstructor() {
        if (Modifier.isAbstract(this.pojoClass.getModifiers())) {
            return null;
        }
        int leastNArgs = Integer.MAX_VALUE;
        Constructor<?> leastArgs = null;
        for (Constructor<?> constructor : this.pojoClass.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            int nArgs = constructor.getParameterTypes().length;
            if (nArgs == 0) {
                return constructor;
            }
            if (nArgs >= leastNArgs) continue;
            leastArgs = constructor;
        }
        return leastArgs;
    }

    private void findSetters() {
        for (Method method : this.pojoClass.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !Void.TYPE.equals(method.getReturnType()) || 1 != method.getParameterTypes().length || !method.getName().startsWith("set")) continue;
            this.setters.add(method);
        }
    }

    public Object createCopyThroughBuilder(Object pojo) {
        PojoBuilder builder = new PojoBuilder(this.pojoClass);
        if (!builder.createBuilder(pojo)) {
            return null;
        }
        if (!builder.isInstanceBuilder()) {
            Map map = (Map)OBJECT_MAPPER.convertValue(pojo, MAP_STRING_TO_OBJECT_TYPE);
            builder.setBuilderValues(map);
        }
        return builder.build();
    }

    private static class Argument {
        private final Class<?> type;
        private final Object standard;
        private boolean variantCreated;
        private Object variant;

        public Argument(Class<?> type) {
            this.type = type;
            this.standard = STANDARD_VALUES.get(type);
        }

        public Object getArgument(boolean useVariant) {
            if (useVariant) {
                if (!this.variantCreated) {
                    this.variant = PojoClass.createInstance(this.type);
                    this.variantCreated = true;
                }
                return this.variant;
            }
            return this.standard;
        }
    }
}

