/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import java.io.IOException;
import org.honton.chas.testpojo.PojoClass;

public class PojoClassTester {
    static ClassLoader classLoader;
    private final PojoClass pojoClass;

    public static void setClassLoader(ClassLoader classLoader) {
        PojoClassTester.classLoader = classLoader;
    }

    public PojoClassTester(String pojoClassName) throws Exception {
        this.pojoClass = PojoClass.from(classLoader.loadClass(pojoClassName));
    }

    public boolean test() throws Exception {
        if (!this.pojoClass.isConstructable()) {
            return true;
        }
        Object standard = this.createVariant(-1);
        if (standard == null) {
            return false;
        }
        int variantCount = this.pojoClass.getVariationCount();
        if (variantCount > 0 && !this.testVariationInEquality(standard, variantCount)) {
            return false;
        }
        if (!standard.equals(standard)) {
            System.err.println("this !== this");
            return false;
        }
        if (standard.equals(null)) {
            System.err.println("this == null");
            return false;
        }
        if (standard.equals(new Object())) {
            System.err.println("this == new Object()");
            return false;
        }
        return true;
    }

    private boolean testVariationInEquality(Object standard, int variantCount) throws Exception {
        Object prior = standard;
        for (int i = 0; i < variantCount; ++i) {
            Object variant = this.createVariant(i);
            if (variant == null) continue;
            if (PojoClassTester.areEqual(prior, variant)) {
                return false;
            }
            prior = variant;
        }
        return prior == standard || !PojoClassTester.areEqual(prior, standard);
    }

    private static boolean areEqual(Object prior, Object variant) {
        boolean equal = variant.equals(prior);
        if (equal) {
            System.err.println(variant + " == " + prior);
        }
        return equal;
    }

    private Object createVariant(int variantIdx) throws Exception {
        Object variant = this.pojoClass.createVariant(variantIdx);
        if (variant == null) {
            return null;
        }
        variant.toString();
        if (!this.testJacksonSerialization(variant)) {
            return null;
        }
        Object copy = this.pojoClass.createCopyThroughBuilder(variant);
        if (copy != null && !this.comparePojos(variant, copy)) {
            return null;
        }
        return variant;
    }

    private boolean testJacksonSerialization(Object variant) throws IOException {
        return !this.pojoClass.isJacksonSerializable() || this.comparePojos(variant, this.pojoClass.createCopyThroughMap(variant)) && this.comparePojos(variant, this.pojoClass.createCopyThroughString(variant));
    }

    private boolean comparePojos(Object pojo, Object copy) {
        if (pojo == copy) {
            System.err.println("pojo === copy");
            return false;
        }
        if (!pojo.equals(copy)) {
            System.err.println(pojo + " != " + copy);
            return false;
        }
        if (pojo.hashCode() != copy.hashCode()) {
            System.err.println("hashCode " + pojo.hashCode() + " != " + copy.hashCode());
            return false;
        }
        return true;
    }
}

