/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class BuildExecJar {
    private final File jarLocation;
    private final String mainClass;

    public final void buildJar(Set<String> classPath) throws IOException {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        mainAttributes.put(Attributes.Name.CLASS_PATH, this.createClassPath(classPath));
        new JarOutputStream((OutputStream)new FileOutputStream(this.jarLocation), manifest).close();
    }

    private String createClassPath(Set<String> jars) {
        StringBuilder cp = new StringBuilder();
        for (String dependency : jars) {
            cp.append(dependency);
            if (!dependency.endsWith(".jar")) {
                cp.append('/');
            }
            cp.append(' ');
        }
        return cp.toString();
    }

    @ConstructorProperties(value={"jarLocation", "mainClass"})
    public BuildExecJar(File jarLocation, String mainClass) {
        this.jarLocation = jarLocation;
        this.mainClass = mainClass;
    }
}

