/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.honton.chas.testpojo.PojoBuilder;

public class PojoClass {
    private static final TypeReference<Map<String, Object>> MAP_STRING_TO_OBJECT_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new GuavaModule()).registerModule((Module)new JodaModule()).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(SerializationFeature.WRITE_DATES_WITH_ZONE_ID);
    private static final Map<Class<?>, Object> STANDARD_VALUES = new HashMap<Class<?>, Object>(){
        {
            this.put(Boolean.TYPE, false);
            this.put(Byte.TYPE, (byte)0);
            this.put(Character.TYPE, Character.valueOf('\u0000'));
            this.put(Short.TYPE, (short)0);
            this.put(Integer.TYPE, 0);
            this.put(Long.TYPE, 0L);
            this.put(Float.TYPE, Float.valueOf(0.0f));
            this.put(Double.TYPE, 0.0);
        }
    };
    private static final Map<Class<?>, Object> VARIANT_VALUES = new HashMap<Class<?>, Object>(){
        {
            this.put(Boolean.TYPE, true);
            this.put(Byte.TYPE, (byte)1);
            this.put(Character.TYPE, Character.valueOf('\u0001'));
            this.put(Short.TYPE, (short)1);
            this.put(Integer.TYPE, 1);
            this.put(Long.TYPE, 1L);
            this.put(Float.TYPE, Float.valueOf(1.0f));
            this.put(Double.TYPE, 1.0);
            this.put(Boolean.class, Boolean.TRUE);
            this.put(Byte.class, new Byte(1));
            this.put(Character.class, new Character('\u0001'));
            this.put(Short.class, new Short(1));
            this.put(Integer.class, new Integer(1));
            this.put(Long.class, new Long(1L));
            this.put(Float.class, new Float(1.0f));
            this.put(Double.class, new Double(1.0));
            this.put(Duration.class, Duration.ZERO);
            this.put(Instant.class, Instant.now());
            this.put(LocalDate.class, LocalDate.now());
            this.put(LocalDateTime.class, LocalDateTime.now());
            this.put(LocalTime.class, LocalTime.now());
            this.put(MonthDay.class, MonthDay.now());
            this.put(OffsetDateTime.class, OffsetDateTime.now());
            this.put(OffsetTime.class, OffsetTime.now());
            this.put(Period.class, Period.ZERO);
            this.put(Year.class, Year.now());
            this.put(YearMonth.class, YearMonth.now());
            this.put(ZonedDateTime.class, ZonedDateTime.now());
            this.put(ZoneId.class, ZoneId.systemDefault());
            this.put(ZoneOffset.class, ZoneOffset.UTC);
        }
    };
    private static Map<Class<?>, PojoClass> cache = new HashMap();
    private final Class<?> pojoClass;
    private final Constructor<?> constructor;
    private final List<Method> setters = new ArrayList<Method>();
    private Argument[] arguments;

    private PojoClass(Class<?> pojoClass) {
        this.pojoClass = pojoClass;
        this.constructor = this.findConstructor();
        cache.put(pojoClass, this);
        if (this.constructor != null) {
            this.constructor.setAccessible(true);
            this.findSetters();
        }
    }

    public static PojoClass from(Class<?> pojoClass) {
        PojoClass pc = cache.get(pojoClass);
        return pc == null ? new PojoClass(pojoClass) : pc;
    }

    private Argument[] getArguments() {
        block4: {
            if (this.arguments != null) break block4;
            Class<?>[] argTypes = this.constructor.getParameterTypes();
            if (argTypes.length > 0) {
                this.arguments = new Argument[argTypes.length];
                int i = 0;
                for (Class<?> argType : argTypes) {
                    this.arguments[i++] = new Argument(argType);
                }
            } else {
                this.arguments = new Argument[this.setters.size()];
                int i = 0;
                for (Method setter : this.setters) {
                    Class<?> argType = setter.getParameterTypes()[0];
                    this.arguments[i++] = new Argument(argType);
                }
            }
        }
        return this.arguments;
    }

    public boolean isConstructable() {
        return this.constructor != null;
    }

    public static boolean isJacksonSerializable(Object value) {
        try {
            return value.getClass().getAnnotation(JsonIgnoreType.class) == null && PojoClass.createCopyThroughString(value) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object createCopyThroughMap(Object pojo) {
        Map map = (Map)OBJECT_MAPPER.convertValue(pojo, MAP_STRING_TO_OBJECT_TYPE);
        return OBJECT_MAPPER.convertValue((Object)map, pojo.getClass());
    }

    public static Object createCopyThroughString(Object pojo) throws IOException {
        String json = OBJECT_MAPPER.writeValueAsString(pojo);
        return OBJECT_MAPPER.readValue(json, pojo.getClass());
    }

    public int getVariationCount() {
        return Math.max(this.constructor.getParameterCount(), this.setters.size());
    }

    public String getPojoClassSimpleName() {
        return this.pojoClass.getSimpleName();
    }

    public Object createVariant(int variantIdx) throws Exception {
        Object[] args = this.createInstantiationArgs(variantIdx);
        if (args == null) {
            return null;
        }
        Object o = this.constructor.newInstance(args);
        if (variantIdx >= this.constructor.getParameterCount()) {
            Method setter = this.setters.get(variantIdx);
            Object variant = PojoClass.createInstance(setter.getParameterTypes()[0]);
            if (variant == null) {
                return null;
            }
            setter.invoke(o, variant);
        }
        return o;
    }

    private Object[] createInstantiationArgs(int variantIdx) {
        Argument[] arguments = this.getArguments();
        Object[] args = new Object[this.constructor.getParameterCount()];
        for (int i = 0; i < args.length; ++i) {
            boolean isVariantIdx = i == variantIdx;
            Object arg = arguments[i].getArgument(isVariantIdx);
            if (isVariantIdx && arg == null) {
                return null;
            }
            args[i] = arg;
        }
        return args;
    }

    private static Object createInstance(Class<?> argType) {
        Object rc = VARIANT_VALUES.get(argType);
        if (rc != null) {
            return rc;
        }
        if (argType.isAssignableFrom(Collection.class) || argType.isAssignableFrom(List.class)) {
            return new ArrayList();
        }
        if (argType.isAssignableFrom(Map.class)) {
            return new HashMap();
        }
        if (argType.isAssignableFrom(ImmutableList.class)) {
            return ImmutableList.of();
        }
        if (argType.isEnum()) {
            return PojoClass.getFirstEnumValue(argType);
        }
        PojoClass pc = PojoClass.from(argType);
        if (pc.isConstructable()) {
            try {
                return pc.createVariant(-1);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return null;
            }
        }
        System.out.println("could not create instance of " + argType.getCanonicalName());
        return null;
    }

    private static Object getFirstEnumValue(Class<?> enumClass) {
        try {
            Object[] values = (Object[])enumClass.getDeclaredMethod("values", new Class[0]).invoke(null, new Object[0]);
            return values.length > 0 ? values[0] : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Constructor<?> findConstructor() {
        if (Modifier.isAbstract(this.pojoClass.getModifiers())) {
            System.out.println("Abstract class " + this.pojoClass.getCanonicalName());
            return null;
        }
        if (this.pojoClass.isMemberClass() && !Modifier.isStatic(this.pojoClass.getModifiers())) {
            System.out.println("Non-static inner class " + this.pojoClass.getCanonicalName());
            return null;
        }
        int leastNArgs = Integer.MAX_VALUE;
        Constructor<?> leastArgs = null;
        for (Constructor<?> constructor : this.pojoClass.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            int nArgs = constructor.getParameterCount();
            if (nArgs == 0) {
                return constructor;
            }
            if (nArgs >= leastNArgs) continue;
            leastArgs = constructor;
        }
        if (leastArgs == null) {
            System.out.println("No public constructor for " + this.pojoClass.getCanonicalName());
        }
        return leastArgs;
    }

    private void findSetters() {
        for (Method method : this.pojoClass.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || 1 != method.getParameterCount() || !method.getName().startsWith("set") || !Void.TYPE.equals(method.getReturnType()) && !method.getReturnType().isAssignableFrom(this.pojoClass)) continue;
            this.setters.add(method);
        }
    }

    public Object createCopyThroughBuilder(Object pojo) {
        PojoBuilder builder = new PojoBuilder(this.pojoClass);
        if (!builder.createBuilder(pojo)) {
            return null;
        }
        if (!builder.isInstanceBuilder()) {
            Map map = (Map)OBJECT_MAPPER.convertValue(pojo, MAP_STRING_TO_OBJECT_TYPE);
            builder.setBuilderValues(map);
        }
        return builder.build();
    }

    private static class Argument {
        private final Class<?> type;
        private final Object standard;
        private boolean variantCreated;
        private Object variant;

        public Argument(Class<?> type) {
            this.type = type;
            this.standard = STANDARD_VALUES.get(type);
        }

        public Object getArgument(boolean useVariant) {
            if (useVariant) {
                if (!this.variantCreated) {
                    this.variant = PojoClass.createInstance(this.type);
                    this.variantCreated = true;
                }
                return this.variant;
            }
            return this.standard;
        }
    }
}

