/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.testpojo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.honton.chas.testpojo.BuildExecJar;
import org.honton.chas.testpojo.JavaProcess;
import org.honton.chas.testpojo.Main;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class TestPojoMojo
extends AbstractMojo {
    @Parameter(property="project.runtimeClasspathElements", readonly=true)
    private List<String> runtimeScope;
    @Parameter(property="project.compileClasspathElements", readonly=true)
    private List<String> compileScope;
    @Parameter(property="project.build.outputDirectory", readonly=true)
    private String outputDirectory;
    @Parameter(property="project.build.directory", readonly=true)
    private String buildDirectory;
    @Parameter(property="project.model.properties", readonly=true)
    private Map<String, String> properties;
    @Parameter(defaultValue="${skipTests}", property="testpojo.skip")
    private boolean skip;
    private static final Pattern ARG_PATTERN = Pattern.compile("@\\{([^}]+)\\}");

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping testpojo execution");
            return;
        }
        if (!new File(this.buildDirectory).isDirectory()) {
            this.getLog().info((CharSequence)"No classes, skipping");
            return;
        }
        String argLine = this.properties.get("argLine");
        if (argLine == null) {
            this.getLog().info((CharSequence)"No argLine specifying javaagent - jacoco coverage may not be effective");
        }
        List<String> arguments = this.replaceProperties(argLine);
        try {
            File jarFile = new File(this.buildDirectory, "testPojo.jar");
            new BuildExecJar(jarFile, Main.class.getCanonicalName()).buildJar(this.getClassPath());
            JavaProcess proc = new JavaProcess(this.getLog());
            arguments.add("-jar");
            arguments.add(jarFile.getAbsolutePath());
            proc.setJavaArgs(arguments);
            proc.setCmdArgs(Arrays.asList(this.outputDirectory, this.createDependencyFile()));
            int errors = proc.execute();
            if (errors > 0) {
                this.getLog().info((CharSequence)(errors + " pojos had errors"));
            }
        }
        catch (MojoExecutionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    private String createDependencyFile() throws IOException {
        File dependencyFile = new File(this.buildDirectory, "testPojo.dependencies");
        try (BufferedWriter dependencies = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dependencyFile), StandardCharsets.UTF_8));){
            TestPojoMojo.write(dependencies, this.runtimeScope);
            TestPojoMojo.write(dependencies, this.compileScope);
        }
        return dependencyFile.getAbsolutePath();
    }

    private static void write(BufferedWriter dependencies, List<String> dependencyScope) throws IOException {
        for (String dependency : dependencyScope) {
            dependencies.write(dependency);
            dependencies.newLine();
        }
    }

    private Set<String> getClassPath() throws URISyntaxException {
        HashSet<String> classPath = new HashSet<String>();
        URLClassLoader ucl = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        for (URL url : ucl.getURLs()) {
            classPath.add(url.toURI().getPath());
        }
        return classPath;
    }

    private List<String> replaceProperties(String argLine) {
        ArrayList<String> params = new ArrayList<String>();
        if (argLine != null) {
            for (String param : argLine.split(" ")) {
                String property = this.replaceProperty(param);
                if (property.isEmpty()) continue;
                params.add(property);
            }
        }
        return params;
    }

    private String replaceProperty(String argLine) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        Matcher m = ARG_PATTERN.matcher(argLine);
        while (m.find()) {
            String value = this.properties.get(m.group(1));
            if (value == null) continue;
            sb.append(argLine, start, m.start());
            sb.append(value);
            start = m.end();
        }
        if (start != 0) {
            return sb.append(argLine.substring(start)).toString();
        }
        return argLine;
    }
}

