/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.touch.maven.plugin;

import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;

public final class PosixAttributes {
    public static FileAttribute<Set<PosixFilePermission>> getFilePermission(String mode) {
        return PosixFilePermissions.asFileAttribute(PosixAttributes.toPosixSet(mode));
    }

    public static Set<PosixFilePermission> toPosixSet(String mode) {
        return PosixAttributes.toPosixSet(Integer.parseInt(mode, mode.charAt(0) == '0' ? 8 : 10));
    }

    public static Set<PosixFilePermission> toPosixSet(int mode) {
        EnumSet<PosixFilePermission> set = EnumSet.noneOf(PosixFilePermission.class);
        int mask = 256;
        for (PosixFilePermission permission : PosixFilePermission.values()) {
            if ((mode & mask) != 0) {
                set.add(permission);
            }
            mask >>= 1;
        }
        return set;
    }

    private PosixAttributes() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

