/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.touch.maven.plugin;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.honton.chas.touch.maven.plugin.PosixAttributes;
import org.honton.chas.touch.maven.plugin.Scanner;

@Mojo(name="touch", threadSafe=true)
public class TouchMojo
extends AbstractMojo {
    @Parameter(property="touch.skip", defaultValue="false")
    private boolean skipTouch;
    @Parameter(property="touch.time", required=true)
    private String modificationTime;
    @Parameter(required=true)
    private FileSet files;
    private static final Pattern IS_POSITIVE_INTEGER = Pattern.compile("\\d+");

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTouch) {
            this.getLog().info((CharSequence)"skipping touch");
            return;
        }
        FileTime fileTime = this.getEpochTime();
        try {
            FileAttribute[] dirAttrs = this.getPosixAttrs(this.files.getDirectoryMode());
            FileAttribute[] fileAttrs = this.getPosixAttrs(this.files.getFileMode());
            new Scanner(this.files).walkTree(path -> {
                if (Files.exists(path, new LinkOption[0])) {
                    Files.setLastModifiedTime(path, fileTime);
                } else {
                    Files.createDirectories(path.getParent(), dirAttrs);
                    Files.createFile(path, fileAttrs);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private FileAttribute<?>[] getPosixAttrs(String mode) {
        if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            return new FileAttribute[]{PosixAttributes.getFilePermission(mode)};
        }
        return new FileAttribute[0];
    }

    FileTime getEpochTime() {
        if (IS_POSITIVE_INTEGER.matcher(this.modificationTime).matches()) {
            return FileTime.from(Long.parseLong(this.modificationTime), TimeUnit.SECONDS);
        }
        return FileTime.from(ZonedDateTime.parse(this.modificationTime).toInstant());
    }
}

