/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.touch.maven.plugin;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.honton.chas.touch.maven.plugin.PosixAttributes;
import org.honton.chas.touch.maven.plugin.Scanner;

@Mojo(name="touch", threadSafe=true)
public class TouchMojo
extends AbstractMojo {
    private static final Pattern IS_POSITIVE_INTEGER = Pattern.compile("\\d+");
    @Parameter(property="touch.skip", defaultValue="false")
    private boolean skipTouch;
    @Parameter(property="touch.time", required=true)
    private String modificationTime;
    @Parameter(required=true)
    private FileSet files;

    private static FileAttribute<?>[] getPosixAttrs(FileSystem fileSystem, String mode) {
        if (fileSystem.supportedFileAttributeViews().contains("posix")) {
            return new FileAttribute[]{PosixAttributes.getFilePermission(mode)};
        }
        return new FileAttribute[0];
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTouch) {
            this.getLog().info((CharSequence)"skipping touch");
            return;
        }
        FileTime fileTime = this.getEpochTime();
        try {
            Path root = TouchMojo.getRootPath(this.files);
            FileSystem fileSystem = root.getFileSystem();
            FileAttribute[] dirAttrs = TouchMojo.getPosixAttrs(fileSystem, this.files.getDirectoryMode());
            FileAttribute[] fileAttrs = TouchMojo.getPosixAttrs(fileSystem, this.files.getFileMode());
            if (this.files.getDirectory() != null) {
                Files.createDirectories(root, dirAttrs);
            }
            new Scanner(this.files, root).walkTree(path -> {
                if (Files.exists(path, new LinkOption[0])) {
                    Files.setLastModifiedTime(path, fileTime);
                } else {
                    Path parent = path.getParent();
                    if (parent == null) {
                        this.getLog().info((CharSequence)("No parent for " + String.valueOf(path)));
                    } else {
                        Files.createDirectories(path.getParent(), dirAttrs);
                    }
                    Files.createFile(path, fileAttrs);
                    Files.setLastModifiedTime(path, fileTime);
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private static Path getRootPath(FileSet files) {
        String dir = files.getDirectory();
        return dir == null ? Paths.get(System.getProperty("user.dir"), new String[0]) : Paths.get(dir, new String[0]).toAbsolutePath().normalize();
    }

    FileTime getEpochTime() {
        if (IS_POSITIVE_INTEGER.matcher(this.modificationTime).matches()) {
            return FileTime.from(Long.parseLong(this.modificationTime), TimeUnit.SECONDS);
        }
        return FileTime.from(ZonedDateTime.parse(this.modificationTime).toInstant());
    }
}

