/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.touch.maven.plugin;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.shared.model.fileset.FileSet;

public class Scanner {
    private final FileSet files;
    private final Path root;
    private final Set<Path> concretePaths = new HashSet<Path>();
    private final Set<PathMatcher> includePatterns = new HashSet<PathMatcher>();
    private final Set<PathMatcher> excludePatterns;

    public Scanner(FileSet files, Path root) throws IOException {
        this.files = files;
        this.root = root;
        FileSystem fileSystem = root.getFileSystem();
        this.excludePatterns = files.getExcludes().stream().map(exclude -> fileSystem.getPathMatcher("glob:" + exclude)).collect(Collectors.toSet());
        files.getIncludes().forEach(include -> {
            if (Scanner.isConcrete(include)) {
                Path includePath = Path.of(include, new String[0]);
                if (!this.anyMatch(this.excludePatterns, includePath)) {
                    this.concretePaths.add(includePath);
                }
            } else {
                this.includePatterns.add(fileSystem.getPathMatcher("glob:" + include));
            }
        });
        if (files.getIncludes().isEmpty()) {
            this.includePatterns.add(fileSystem.getPathMatcher("glob:**"));
        }
    }

    static boolean isConcrete(String path) {
        return path.indexOf(42) < 0 && path.indexOf(63) < 0 && path.indexOf(91) < 0 && path.indexOf(123) < 0;
    }

    public void walkTree(final PathConsumer consumer) throws IOException {
        final HashSet<Path> toVisit = new HashSet<Path>(this.concretePaths);
        Files.walkFileTree(this.root, this.files.isFollowSymlinks() ? Set.of(FileVisitOption.FOLLOW_LINKS) : Set.of(), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                Path relative = Scanner.this.root.relativize(path);
                if ((toVisit.remove(relative) || Scanner.this.anyMatch(Scanner.this.includePatterns, relative)) && !Scanner.this.anyMatch(Scanner.this.excludePatterns, relative)) {
                    consumer.accept(path);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        toVisit.forEach(p -> this.ignoreIOException(consumer, this.root.resolve((Path)p)));
    }

    private void ignoreIOException(PathConsumer consumer, Path p) {
        consumer.accept(p);
    }

    private boolean anyMatch(Set<PathMatcher> pathMatchers, Path path) {
        return pathMatchers.stream().anyMatch(e -> e.matches(path));
    }

    @FunctionalInterface
    public static interface PathConsumer {
        public void accept(Path var1) throws IOException;
    }
}

