/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.touch.maven.plugin;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.ZonedDateTime;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.honton.chas.touch.maven.plugin.PosixAttributes;
import org.honton.chas.touch.maven.plugin.Scanner;

@Mojo(name="touch", threadSafe=true)
public class TouchMojo
extends AbstractMojo {
    private static final Pattern IS_POSITIVE_INTEGER = Pattern.compile("\\d+");
    @Parameter(property="touch.skip", defaultValue="false")
    private boolean skipTouch;
    @Parameter(property="touch.time")
    private String modificationTime;
    @Parameter(required=true)
    private FileSet files;

    private static Set<PosixFilePermission> getPosixAttrs(FileSystem fileSystem, String mode) {
        if (fileSystem.supportedFileAttributeViews().contains("posix")) {
            return PosixAttributes.getFilePermission(mode);
        }
        return Set.of();
    }

    private static Path getRootPath(FileSet files) {
        String dir = files.getDirectory();
        return dir == null ? Paths.get(System.getProperty("user.dir"), new String[0]) : Paths.get(dir, new String[0]).toAbsolutePath().normalize();
    }

    private void createDirs(Path path, Set<PosixFilePermission> dirAttrs) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            this.createDirs(path.getParent(), dirAttrs);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Creating " + path + " with permissions " + PosixFilePermissions.toString(dirAttrs)));
            }
            Files.createDirectory(path, new FileAttribute[0]);
            if (!dirAttrs.isEmpty()) {
                Files.setPosixFilePermissions(path, dirAttrs);
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTouch) {
            this.getLog().info((CharSequence)"skipping touch");
            return;
        }
        FileTime fileTime = this.getEpochTime();
        try {
            Path root = TouchMojo.getRootPath(this.files);
            FileSystem fileSystem = root.getFileSystem();
            Set<PosixFilePermission> dirAttrs = TouchMojo.getPosixAttrs(fileSystem, this.files.getDirectoryMode());
            Set<PosixFilePermission> fileAttrs = TouchMojo.getPosixAttrs(fileSystem, this.files.getFileMode());
            if (this.files.getDirectory() != null) {
                this.createDirs(root, dirAttrs);
            }
            new Scanner(this.files, root).walkTree(path -> this.touch(path, fileTime, dirAttrs, fileAttrs));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void touch(Path path, FileTime fileTime, Set<PosixFilePermission> dirAttrs, Set<PosixFilePermission> fileAttrs) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Setting modified time of " + path + " to " + fileTime));
                }
            } else {
                Path parent = path.getParent();
                if (parent == null) {
                    this.getLog().info((CharSequence)("No parent for " + path));
                } else {
                    this.createDirs(path.getParent(), dirAttrs);
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Creating " + path + " with permissions " + PosixFilePermissions.toString(fileAttrs) + " and time " + fileTime));
                }
                Files.createFile(path, new FileAttribute[0]);
                if (!fileAttrs.isEmpty()) {
                    Files.setPosixFilePermissions(path, fileAttrs);
                }
            }
            Files.setLastModifiedTime(path, fileTime);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)e.getMessage());
        }
    }

    FileTime getEpochTime() {
        if (this.modificationTime == null) {
            return FileTime.from(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }
        if (IS_POSITIVE_INTEGER.matcher(this.modificationTime).matches()) {
            return FileTime.from(Long.parseLong(this.modificationTime), TimeUnit.SECONDS);
        }
        return FileTime.from(ZonedDateTime.parse(this.modificationTime).toInstant());
    }
}

