/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.jca.vault.provider;

import java.nio.file.ProviderNotFoundException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.honton.chas.jca.vault.provider.keygen.VaultKeyGenerator;
import org.honton.chas.jca.vault.provider.keygen.VaultKeyInfo;
import org.honton.chas.jca.vault.provider.keygen.ecdsa.VaultEcdsaKeyGenerator;
import org.honton.chas.jca.vault.provider.keygen.rsa.VaultRsaKeyGenerator;
import org.honton.chas.jca.vault.provider.keystore.VaultKeyStore;
import org.honton.chas.jca.vault.provider.signature.SignatureAlgorithm;
import org.honton.chas.jca.vault.provider.signature.VaultSignature;

public final class VaultProvider
extends Provider {
    public static final String NAME = "Vault";

    public VaultProvider() {
        super(NAME, "1.0", "Hashicorp Vault Provider");
        this.putService(new VaultKeyPairGeneratorService("RSA", VaultRsaKeyGenerator.class, VaultRsaKeyGenerator::new));
        this.putService(new VaultKeyPairGeneratorService("RSASSA-PSS", VaultRsaKeyGenerator.class, VaultRsaKeyGenerator::new));
        this.putService(new VaultKeyPairGeneratorService("EC", VaultEcdsaKeyGenerator.class, VaultEcdsaKeyGenerator::new));
        this.putService(new VaultKeyStoreService());
        for (SignatureAlgorithm algorithm : SignatureAlgorithm.values()) {
            this.putService(new VaultSignatureService(algorithm));
        }
    }

    public static Provider register() {
        Provider vault = Security.getProvider(NAME);
        if (vault == null) {
            ServiceLoader<Provider> sl = ServiceLoader.load(Provider.class);
            vault = (Provider)sl.stream().filter(pp -> ((Provider)pp.get()).getName().equals(NAME)).findFirst().orElseThrow(() -> new ProviderNotFoundException("Vault is missing")).get();
            Security.addProvider(vault);
        }
        return vault;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof VaultProvider;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    private class VaultKeyPairGeneratorService<P extends AlgorithmParameterSpec & VaultKeyInfo, T extends VaultKeyGenerator<P>>
    extends Provider.Service {
        Supplier<T> ctr;

        private VaultKeyPairGeneratorService(String keyPairGeneratorAlgorithm, Class<T> generatorClass, Supplier<T> ctr) {
            super(VaultProvider.this, "KeyPairGenerator", keyPairGeneratorAlgorithm, generatorClass.getName(), List.of(), Map.of());
            this.ctr = ctr;
        }

        @Override
        public Object newInstance(Object constructorParameter) {
            return this.ctr.get();
        }
    }

    private class VaultKeyStoreService
    extends Provider.Service {
        private VaultKeyStoreService() {
            super(VaultProvider.this, "KeyStore", VaultProvider.NAME, VaultKeyStore.class.getName(), List.of(), Map.of());
        }

        @Override
        public Object newInstance(Object constructorParameter) {
            return new VaultKeyStore();
        }
    }

    private class VaultSignatureService
    extends Provider.Service {
        private final SignatureAlgorithm algorithm;

        private VaultSignatureService(SignatureAlgorithm algorithm) {
            super(VaultProvider.this, "Signature", algorithm.getJcaSignatureAlgorithm(), VaultSignature.class.getName(), List.of(), Map.of());
            this.algorithm = algorithm;
        }

        @Override
        public Object newInstance(Object constructorParameter) {
            return new VaultSignature(this.algorithm);
        }
    }
}

