/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.jca.vault.provider.keygen;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.time.Duration;
import lombok.NonNull;
import org.honton.chas.jca.vault.provider.keygen.VaultKeyFactory;
import org.honton.chas.jca.vault.provider.keygen.VaultKeyInfo;
import org.honton.chas.jca.vault.provider.keygen.VaultParameterSpec;
import org.honton.chas.vault.api.VaultApi;
import org.honton.chas.vault.api.VaultClient;

public class VaultKeyGenerator<P extends AlgorithmParameterSpec & VaultKeyInfo>
extends KeyPairGeneratorSpi {
    private final Class<P> vaultParameterSpecClass;
    private P vaultParameterSpec;
    private String rotation;

    protected VaultKeyGenerator(@NonNull Class<P> vaultParameterSpecClass) {
        if (vaultParameterSpecClass == null) {
            throw new NullPointerException("vaultParameterSpecClass is marked non-null but is null");
        }
        this.vaultParameterSpecClass = vaultParameterSpecClass;
    }

    protected VaultApi getVaultInstance() {
        return VaultClient.INSTANCE;
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        throw new UnsupportedOperationException("initialize with VaultParameterSpec");
    }

    @Override
    public void initialize(@NonNull AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        this.vaultParameterSpec = (AlgorithmParameterSpec)this.vaultParameterSpecClass.cast(params);
        this.rotation = this.rotationAsString(((VaultKeyInfo)this.vaultParameterSpec).getRotation());
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.vaultParameterSpec == null) {
            throw new IllegalStateException("must initialize with " + this.vaultParameterSpecClass.getSimpleName());
        }
        String name = ((VaultKeyInfo)this.vaultParameterSpec).getKeyName();
        VaultApi vaultApi = this.getVaultInstance();
        vaultApi.createKey(name, ((VaultParameterSpec)this.vaultParameterSpec).getKeyType(), this.rotation);
        return VaultKeyFactory.createKeyPair(name, vaultApi.readKey(name));
    }

    private String rotationAsString(Duration rotation) throws InvalidAlgorithmParameterException {
        long hours;
        if (rotation == null) {
            return "0";
        }
        StringBuilder duration = new StringBuilder();
        long days = rotation.toDays();
        if (days > 0L) {
            duration.append(days).append("d");
            rotation = rotation.minusDays(days);
        }
        if ((hours = rotation.toHours()) > 0L) {
            duration.append(hours).append("h");
        }
        if (duration.length() == 0) {
            throw new InvalidAlgorithmParameterException("duration must be greater than 1 hour");
        }
        return duration.toString();
    }
}

